\name{SpTe2M-package}
\alias{SpTe2M-package}
\docType{package}
\title{
Nonparametric Modeling and Monitoring of Spatio-Temporal Data
}
\description{
Spatio-temporal data have become increasingly popular in many research fields. Such data often have complex structures that are difficult to describe and estimate. This package provides reliable tools for modeling complicated spatio-temporal data. It also includes tools of online process monitoring to detect possible change-points in a spatio-temporal process over time. More specifically, it implements the nonparametric spatio-temporal data modeling methods described in 
Yang and Qiu (2018, 2019, and 2022), as well as the online spatio-temporal process monitoring methods 
discussed in Qiu and Yang (2021 and 2022) and Yang and Qiu (2020).
}
\details{
\tabular{rl}{
Package: \tab SpTe2M\cr
Type: \tab Package\cr
Version: \tab 1.0.0\cr
Date: \tab 2022-06-03\cr
License: \tab GPL (>= 3)\cr
}
}

\author{Kai Yang, Peihua Qiu
	
	Maintainer: Kai Yang <kayang@mcw.edu>
}
\references{Qiu, P. and Yang, K. (2021). Effective Disease Surveillance by Using Covariate Information. \emph{Statistics in Medicine}, \strong{40}, 5725-5745. 
	
	Qiu, P. and Yang, K. (2022). Spatio-Temporal Process Monitoring Using Exponentially Weighted Spatial LASSO. \emph{Journal of Quality Technology}, DOI: 10.1080/00224065.2022.2081104.
	
	Yang, K. and Qiu, P. (2018). Spatio-Temporal Incidence Rate Data Analysis by Nonparametric Regression. \emph{Statistics in Medicine}, \strong{37}, 2094-2107.
	
	Yang, K. and Qiu, P. (2019). Nonparametric Estimation of the Spatio-Temporal Covariance Structure. \emph{Statistics in Medicine}, \strong{38}, 4555-4565.
	
	Yang, K. and Qiu, P. (2020). Online Sequential Monitoring of Spatio-Temporal Disease Incidence Rates. \emph{IISE Transactions}, \strong{52}, 1218-1233.
	
	Yang, K. and Qiu, P. (2022). A Three-Step Local Smoothing Approach for Estimating the Mean and Covariance Functions of Spatio-Temporal Data. \emph{Annals of the Institute of Statistical Mathematics}, \strong{74}, 49-68.

}
\keyword{package}
