% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{possible_L_R_pairs_cellchat}
\alias{possible_L_R_pairs_cellchat}
\title{CellChat Database: Identify Possible Ligand-Receptor Pairs for Cell-Cell Communication}
\usage{
possible_L_R_pairs_cellchat(
  species,
  gene_spot_expression_dataframe,
  percentage
)
}
\arguments{
\item{species}{A string specifying the species ("Human" or "Mouse"). The function selects the appropriate CellChatDB object, typically 'CellChatDB.human' or 'CellChatDB.mouse', which contains information on ligand-receptor interactions.}

\item{gene_spot_expression_dataframe}{A gene expression data frame with genes as row names and Spot IDs as column names. This data frame is used to verify the presence of all genes involved in the L-R pairs.}

\item{percentage}{A numeric value specifying the minimum percentage of spots in which a gene must be expressed to be considered. The default is 10.}
}
\value{
A list containing:
\describe{
  \item{possible_L_R_pairs}{A data frame of L-R pairs where all genes are present in the 'gene_spot_expression_dataframe'. The data frame includes the ligand and receptor vectors, and the combined gene vectors.}
  \item{possible_L_R_pairs_details}{A data frame with detailed information about the L-R pairs, including the original annotations from the CellChatDB.}
}
}
\description{
This function identifies possible ligand-receptor (L-R) pairs for cell-cell communication analysis using a subset of the CellChat database. It checks for the presence of all genes involved in each L-R pair within the provided gene expression matrix.
}
\examples{

\donttest{
library(SpaCCI)
#Load the example data
load(system.file("extdata", "Tutorial_example_data.rda", package = "SpaCCI"))
Example_Seurat <- NormalizeData(Example_Seurat)
gene_spot_df <- as.data.frame(Example_Seurat@assays$Spatial@data)
result <- possible_L_R_pairs_cellchat(CellChatDB.human,
      gene_spot_expression_dataframe = gene_spot_df)
}
}
