% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{params}
\alias{params}
\alias{simList-accessors-params}
\alias{params,.simList-method}
\alias{params<-}
\alias{params<-}
\alias{params<-,.simList-method}
\alias{P}
\alias{simList-accessors-params}
\alias{parameters}
\alias{parameters,.simList-method}
\title{Get and set simulation parameters.}
\usage{
params(sim)

\S4method{params}{.simList}(sim)

params(sim) <- value

\S4method{params}{.simList}(sim) <- value

P(sim, module, param)

parameters(sim, asDF = FALSE)

\S4method{parameters}{.simList}(sim, asDF = FALSE)
}
\arguments{
\item{sim}{A \code{simList} object from which to extract element(s) or
in which to replace element(s).}

\item{value}{The object to be stored at the slot.}

\item{module}{Optional character string indicating which module params should come from.}

\item{param}{Optional character string indicating which parameter to choose.}

\item{asDF}{Logical. For \code{parameters}, if TRUE, this will produce a single
data.frame of all model parameters. If FALSE, then it will return
a data.frame with 1 row for each parameter within nested lists,
with the same structure as \code{params}.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
\code{params} and \code{P} access the parameter slot in the \code{simList}.
\code{params} has a replace method, so can be used to update a parameter value.

\code{P} is a concise way to access parameters within a module. It works more like
a namespaced function in the sense that the module from which it is called is the
default place it will look for the parameter. To access a parameter from within
a module, you can use \code{P(sim)$paramName} instead of
\code{params(sim)$moduleName$paramName}
}
\note{
The differences between P, params and being explicit with passing arguments
are mostly a question of speed and code compactness.
The computationally fastest way to get a parameter is to specify moduleName and parameter name, as in:
\code{P(sim, "moduleName", "paramName")} (replacing moduleName and paramName with your
specific module and parameter names), but it is more verbose than P(sim)$paramName. Note: the important
part for speed (e.g., 2-4x faster) is specifying the moduleName.
Specifying the parameter name is <5% faster.
}
\examples{
modules <- list("randomLandscapes")
paths <- list(modulePath = system.file("sampleModules", package = "SpaDES.core"))
mySim <- simInit(modules = modules, paths = paths,
                 params = list(.globals = list(stackName = "landscape")))
parameters(mySim)

}
\seealso{
\code{\link{SpaDES.core-package}}, specifically the section 1.2.1 on Simulation parameters.

Other functions to access elements of a \code{simList} object: \code{\link{.addDepends}},
  \code{\link{doEvent.checkpoint}}, \code{\link{envir}},
  \code{\link{events}}, \code{\link{globals}},
  \code{\link{inputs}}, \code{\link{ls.simList}},
  \code{\link{ls.str.simList}}, \code{\link{modules}},
  \code{\link{objs}}, \code{\link{packages}},
  \code{\link{paths}}, \code{\link{progressInterval}},
  \code{\link{times}}
}
