% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project-template.R
\name{newProject}
\alias{newProject}
\alias{newProject,character,character,logical-method}
\alias{newProject,character,character,missing-method}
\title{Create new SpaDES project}
\usage{
newProject(name, path, open)

\S4method{newProject}{character,character,logical}(name, path, open)

\S4method{newProject}{character,character,missing}(name, path, open)
}
\arguments{
\item{name}{project name (name of project directory)}

\item{path}{path to directory in which to create the project directory}

\item{open}{Logical. Should the new project file be opened after creation?
Default \code{TRUE} in an interactive session.}
}
\description{
Initialize a project with subdirectories \file{cache/}, \file{modules/},
\file{inputs/}, \file{outputs/}, and \code{setPaths} accordingly.
}
\examples{
myProjDir <- newProject("myProject", tempdir())

dir.exists(file.path(myProjDir, "cache"))
dir.exists(file.path(myProjDir, "inputs"))
dir.exists(file.path(myProjDir, "modules"))
dir.exists(file.path(myProjDir, "outputs"))
unlink(myProjDir, recursive = TRUE) ## cleanup
}
