% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapReduce.R
\name{rasterizeReduced}
\alias{rasterizeReduced}
\title{Convert reduced representation to full raster}
\usage{
rasterizeReduced(
  reduced,
  fullRaster,
  newRasterCols,
  mapcode = names(fullRaster),
  ...
)
}
\arguments{
\item{reduced}{\code{data.frame} or \code{data.table} that has at least one
column of codes that are represented in the \code{fullRaster}.}

\item{fullRaster}{\code{RasterLayer}/\code{SpatRaster} of codes used in \code{reduced} that
represents a spatial representation of the data. Note that
if \code{fullRaster} is a \code{factor} \code{SpatRaster}, the active category
level values are used, not the IDs (see \code{terra::activeCat} and
\code{terra::cats})}

\item{newRasterCols}{Character vector, length 1 or more, with the name(s) of
the column(s) in \code{reduced} whose value will be
returned as a \code{RasterLayer}/\code{SpatRaster} or list
of \code{RasterLayer}/\code{SpatRaster}s.}

\item{mapcode}{a character, length 1, with the name of the column in \code{reduced}
that is represented in \code{fullRaster}.}

\item{...}{Other arguments. None used yet.}
}
\value{
A \code{RasterLayer}/\code{SpatRaster} or list of
\code{RasterLayer}/\code{SpatRaster} of with same dimensions as \code{fullRaster} representing
\code{newRasterCols} spatially, according to the join between the \code{mapcode}
contained within \code{reduced} and \code{fullRaster}
}
\description{
Convert reduced representation to full raster
}
\examples{
library(data.table)
library(terra)

ras <- rast(ext(0, 15, 0, 15), res = 1)
fullRas <- randomPolygons(ras, numTypes = 2)
names(fullRas) <- "mapcodeAll"
uniqueComms <- unique(fullRas)
reducedDT <- data.table(uniqueComms,
                        communities = sample(1:1000, length(uniqueComms)),
                        biomass = rnbinom(length(uniqueComms), mu = 4000, 0.4))
biomass <- rasterizeReduced(reducedDT, fullRas, "biomass")

# The default key is the layer name of the fullRas, so rekey incase of miskey
setkey(reducedDT, biomass)

communities <- rasterizeReduced(reducedDT, fullRas, "communities")
coltab(communities) <- c("blue", "orange", "red")
if (interactive()) {
  terra::plot(c(biomass, communities, fullRas))
}

## with a factor SpatRaster, the mapcode should correspond to the
## active category (not the ids)
cls <- data.frame(id = sort(unique(as.vector(fullRas[]))))
cls$Bclass <- LETTERS[cls$id]
levels(fullRas) <- cls
is.factor(fullRas)

clsDT <- as.data.table(cls)
reducedDT <- reducedDT[clsDT, on = "mapcodeAll==id"]
reducedDT[, mapcodeAll := Bclass]

biomass2 <- rasterizeReduced(reducedDT, fullRas, "biomass")



}
\seealso{
\code{\link[terra:rast]{terra::rast()}}
}
\author{
Eliot McIntire
}
