% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\name{withWatermark}
\alias{withWatermark}
\alias{withWatermark,SparkDataFrame,character,character-method}
\title{withWatermark}
\usage{
withWatermark(x, eventTime, delayThreshold)

\S4method{withWatermark}{SparkDataFrame,character,character}(x, eventTime, delayThreshold)
}
\arguments{
\item{x}{a streaming SparkDataFrame}

\item{eventTime}{a string specifying the name of the Column that contains the event time of the
row.}

\item{delayThreshold}{a string specifying the minimum delay to wait to data to arrive late,
relative to the latest record that has been processed in the form of an
interval (e.g. "1 minute" or "5 hours"). NOTE: This should not be negative.}
}
\value{
a SparkDataFrame.
}
\description{
Defines an event time watermark for this streaming SparkDataFrame. A watermark tracks a point in
time before which we assume no more late data is going to arrive.
}
\details{
Spark will use this watermark for several purposes:
\itemize{
 \item To know when a given time window aggregation can be finalized and thus can be emitted
when using output modes that do not allow updates.
 \item To minimize the amount of state that we need to keep for on-going aggregations.
}
The current watermark is computed by looking at the \code{MAX(eventTime)} seen across
all of the partitions in the query minus a user specified \code{delayThreshold}. Due to the cost
of coordinating this value across partitions, the actual watermark used is only guaranteed
to be at least \code{delayThreshold} behind the actual event time.  In some cases we may still
process records that arrive more than \code{delayThreshold} late.
}
\note{
withWatermark since 2.3.0
}
\examples{
\dontrun{
sparkR.session()
schema <- structType(structField("time", "timestamp"), structField("value", "double"))
df <- read.stream("json", path = jsonDir, schema = schema, maxFilesPerTrigger = 1)
df <- withWatermark(df, "time", "10 minutes")
}
}
\seealso{
Other SparkDataFrame functions: 
\code{\link{SparkDataFrame-class}},
\code{\link{agg}()},
\code{\link{alias}()},
\code{\link{arrange}()},
\code{\link{as.data.frame}()},
\code{\link{attach,SparkDataFrame-method}},
\code{\link{broadcast}()},
\code{\link{cache}()},
\code{\link{checkpoint}()},
\code{\link{coalesce}()},
\code{\link{collect}()},
\code{\link{colnames}()},
\code{\link{coltypes}()},
\code{\link{createOrReplaceTempView}()},
\code{\link{crossJoin}()},
\code{\link{cube}()},
\code{\link{dapplyCollect}()},
\code{\link{dapply}()},
\code{\link{describe}()},
\code{\link{dim}()},
\code{\link{distinct}()},
\code{\link{dropDuplicates}()},
\code{\link{dropna}()},
\code{\link{drop}()},
\code{\link{dtypes}()},
\code{\link{exceptAll}()},
\code{\link{except}()},
\code{\link{explain}()},
\code{\link{filter}()},
\code{\link{first}()},
\code{\link{gapplyCollect}()},
\code{\link{gapply}()},
\code{\link{getNumPartitions}()},
\code{\link{group_by}()},
\code{\link{head}()},
\code{\link{hint}()},
\code{\link{histogram}()},
\code{\link{insertInto}()},
\code{\link{intersectAll}()},
\code{\link{intersect}()},
\code{\link{isLocal}()},
\code{\link{isStreaming}()},
\code{\link{join}()},
\code{\link{limit}()},
\code{\link{localCheckpoint}()},
\code{\link{merge}()},
\code{\link{mutate}()},
\code{\link{ncol}()},
\code{\link{nrow}()},
\code{\link{persist}()},
\code{\link{printSchema}()},
\code{\link{randomSplit}()},
\code{\link{rbind}()},
\code{\link{rename}()},
\code{\link{repartitionByRange}()},
\code{\link{repartition}()},
\code{\link{rollup}()},
\code{\link{sample}()},
\code{\link{saveAsTable}()},
\code{\link{schema}()},
\code{\link{selectExpr}()},
\code{\link{select}()},
\code{\link{showDF}()},
\code{\link{show}()},
\code{\link{storageLevel}()},
\code{\link{str}()},
\code{\link{subset}()},
\code{\link{summary}()},
\code{\link{take}()},
\code{\link{toJSON}()},
\code{\link{unionByName}()},
\code{\link{union}()},
\code{\link{unpersist}()},
\code{\link{withColumn}()},
\code{\link{with}()},
\code{\link{write.df}()},
\code{\link{write.jdbc}()},
\code{\link{write.json}()},
\code{\link{write.orc}()},
\code{\link{write.parquet}()},
\code{\link{write.stream}()},
\code{\link{write.text}()}
}
\concept{SparkDataFrame functions}
