% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda1_calculator.R
\name{lambda1_calculator}
\alias{lambda1_calculator}
\title{Lambda 1 Calculator.}
\usage{
lambda1_calculator(pdat1, pdat2, ncluster, alpha1 = 0.5, nboot1 = 1000)
}
\arguments{
\item{pdat1}{The centered data from condition 1, columns should be
samples (cells) and rows should be features (genes).}

\item{pdat2}{The centered data from condition 2, columns should be
samples (cells) and rows should be features (genes). The number of genes
should be the same as \code{pdat1}.
as in pdat1.}

\item{ncluster}{The number of clusters present in the data.}

\item{alpha1}{The quantile of the bootstrapped lambda 1 values to use,
range is (0,1). The default value is 0.5, the median of the calculated
lambda 1 values.}

\item{nboot1}{The number of bootstrap repetitions used for estimating lambda 1,
the default value is 1000.}
}
\value{
The calculated value of lambda 1 to use in the main SparseDC
algorithm.
}
\description{
Calculates the lambda 1 value for the sparseDC algorithm. The lambda 1
value controls the number of marker genes selected for each
cluster in the output from SparseDC. It is calculated as the value of
lambda 1 that results in no marker genes being selected when then are no
meaningful clusters present in the data. Please see the original manuscript
for further details.
}
\examples{
set.seed(10)
# Select small dataset for example
data_test <- data_biase[1:100,]
# Split data into conditions A and B
data_A <- data_test[ , which(condition_biase == "A")]
data_B <- data_test[ , which(condition_biase == "B")]
# Pre-process the data
pre_data <- pre_proc_data(data_A, data_B, norm = FALSE, log = TRUE,
center = TRUE)
# Calculate the lambda 1 value
lambda1_calculator(pdat1 = pre_data[[1]], pdat2 = pre_data[[2]], ncluster=3,
 alpha1 = 0.5, nboot1 = 1000)

# Can also run

# Pre-process the data
pre_data <- pre_proc_data(data_A, data_B, norm = FALSE, log = TRUE,
center = TRUE)
pdata_A <- pre_data[[1]]
pdata_B <- pre_data[[2]]
# Calculate the lambda 1 value
lambda1_calculator(pdat1 = pdata_A, pdat2 = pdata_B , ncluster=3,
 alpha1 = 0.5, nboot1 = 1000)

}
\seealso{
\code{\link{lambda2_calculator}} for how to calculate the lambda 2
parameter. \code{\link{sparsedc_cluster}} for the main sparse differential
clustering function.
}
