% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_matrix.R
\name{coords_pix}
\alias{coords_pix}
\title{Pixel coordinates generation.}
\usage{
coords_pix(area, pixel.xsize = diff(area$xrange)/ncol,
  pixel.ysize = diff(area$yrange)/nrow,
  nrow = diff(area$yrange)/pixel.ysize,
  ncol = diff(area$xrange)/pixel.xsize)
}
\arguments{
\item{area}{The observation area, an \code{owin} object, see package \code{spatstat}}

\item{pixel.xsize}{A scalar, length of the pixel side along the \eqn{x} axis (unnecessary if \code{ncol} is provided)}

\item{pixel.ysize}{A scalar, length of the pixel side along the \eqn{y} axis (unnecessary if \code{nrow} is provided)}

\item{nrow}{An integer, number of pixels along the \eqn{y} axis (unnecessary if \code{pixel.ysize} is provided)}

\item{ncol}{An integer, number of pixels along the \eqn{x}  axis (unnecessary if \code{pixel.xsize} is provided)}
}
\value{
A two column matrix containing the \eqn{x}  and \eqn{y} coordinates of the pixel centroids.
}
\description{
\code{coords_pix} generates the coordinates of the pixel centroids,
given an obervation area and the pixel size.
The resulting coordinates may be used as arguments of \code{\link[=euclid_dist]{euclid_dist()}}.
}
\details{
When the Euclidean distance is computed between areas, the most common choice is
to use the area centroid as the reference point. This function returns the centroids
of a regular lattice. You can either provide the number of pixels along the two cardinal
directions (using \code{ncol} for the \eqn{x} direction and \code{nrow} for the \eqn{y} direction), or alternatively
provide the pixel size along the two directions (rectangular areas are allowed).
}
\examples{
ccc=coords_pix(area=square(10), nrow=10, ncol=10)
plot(square(10)); points(ccc)

ccc=coords_pix(area=square(10), pixel.xsize = 2, pixel.ysize = 2)
plot(square(10)); points(ccc, pch=16)

}
