% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qMS.R
\name{qMS}
\alias{qMS}
\title{Draw a Simple Mass Spectrum Showing the Parent Ion}
\usage{
qMS(f = NULL, xlab = "m/z", ylab = "intensity", main = "Mass Spectrum",
  ...)
}
\arguments{
\item{f}{A character string giving the molecular formula of the molecule of
interest.  Order of elements does not matter.  Elements should be given
as their atomic symbols, e.g. "Br" not "br".}

\item{xlab}{A character string giving the x axis label.}

\item{ylab}{A character string giving the y axis label.}

\item{main}{A character string giving the title of the plot.}

\item{\dots}{Additional arguments to be passed downstream.}
}
\value{
Draws a plot.  Returns a data frame giving the peak masses and
relative intensites.
}
\description{
Given a molecular formula, this function computes the mass of the parent
ion, including any M + n peaks due to Br or Cl, and plots it.  Intended to
draw the parent ion region for small organic molecules, especially those
with Br or Cl.
}
\details{
The function currently accepts formulas containing C, H, N, O, Br and Cl in
any quantities.
}
\examples{

ms <- qMS(f = "C5H8BrCl", xlim = c(150, 200), main = "Parent Ion of C5H8BrCl")

}
\author{
Bryan A. Hanson, DePauw University. \email{hanson@depauw.edu}
}
\keyword{utilities}

