% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AucDiff.R
\name{AucDiff}
\alias{AucDiff}
\title{Calculate difference between areas under the ROC curve (AUC) between a forecast and a reference forecast for the same observation, and estimate the variance of the AUC difference}
\usage{
AucDiff(fcst, fcst.ref, obs, handle.na = c("na.fail",
  "only.complete.triplets"), use_fn = c("C++", "R"))
}
\arguments{
\item{fcst}{vector of forecasts}

\item{fcst.ref}{vector of reference forecasts}

\item{obs}{vector of binary observations (0 for non-occurrence, 1 for occurrence of the event)}

\item{handle.na}{how should missing values in forecasts and observations be handled; possible values are 'na.fail' and 'only.complete.triplets'; default: 'na.fail'}

\item{use_fn}{the function used for the calculation: 'C++' (default) for the fast C++ implementation, or 'R' for the slow (but more readable) R implementation}
}
\value{
vector with AUC difference, and estimated standard deviation
}
\description{
Calculate difference between areas under the ROC curve (AUC) between a forecast and a reference forecast for the same observation, and estimate the variance of the AUC difference
}
\examples{
data(eurotempforecast)
AucDiff(rowMeans(ens.bin), ens.bin[, 1], obs.bin)
}
\references{
DeLong et al (1988): Comparing the Areas under Two or More Correlated Receiver Operating Characteristic Curves: A Nonparametric Approach. Biometrics. http://dx.doi.org/10.2307/2531595
Sun and Xu (2014): Fast Implementation of DeLong's Algorithm for Comparing the Areas Under Correlated Receiver Operating Characteristic Curves. IEEE Sign Proc Let 21(11). http://dx.doi.org/10.1109/LSP.2014.2337313
}
\seealso{
Auc
}
