% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics_W.R
\name{split_knockoffs.statistics.pathorder.W_fixed}
\alias{split_knockoffs.statistics.pathorder.W_fixed}
\title{split_knockoffs.statistics.pathorder.W_fixed}
\usage{
split_knockoffs.statistics.pathorder.W_fixed(X, D, y, nu, option)
}
\arguments{
\item{X}{the design matrix}

\item{D}{the linear transform}

\item{y}{the response vector}

\item{nu}{the parameter for variable splitting}

\item{option}{options for creating the Knockoff statistics
option$eta the choice of eta for creating the knockoff copy
option$lambda the choice of lambda for the path
option$beta_choice the fixed beta for step 0}
}
\value{
W: the knockoff statistics

Z: feature significance

t_Z: knockoff significance
}
\description{
generate the knockoff statistics W for fixed beta in the intercepetion assignment step,
using the method of path order.
}
\examples{
option <- array(data = NA, dim = length(data), dimnames = NULL)
option$q <- 0.2
option$eta <- 0.1
option$method <- 'knockoff'
option$stage0 <- 'path'
option$normalize <- 'true'
option$cv_rule <- 'min'
option$lambda <- 10.^seq(0, -6, by=-0.01)
option$nu <- 10
option$copy <- 'true'
option <- option[-1]
library(mvtnorm)
sigma <-1
n = 350
p = 100
nu = 10
Sigma = matrix(0, p, p)
X <- rmvnorm(n,matrix(0, p, 1), Sigma)
p <- 100
D <- diag(p)
beta_true <- matrix(0, p, 1)
varepsilon <- rnorm(n) * sqrt(sigma)
y <- X \%*\% beta_true + varepsilon
}
