% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReducedMatrix.R
\name{ReducedMatrix}
\alias{ReducedMatrix}
\title{Matrix reduction}
\usage{
ReducedMatrix(B)
}
\arguments{
\item{B}{a matrix that contains lot of 0s.}
}
\value{
Returns a list including:

\code{BB} the reduced matrix of \code{B}.

\code{ind_col} a vector that contains the index of the remaining columns of \code{B} in \code{BB}.

\code{ind_row} a vector that contains the index of the remaining rows of \code{B} in \code{BB}.
}
\description{
Reduce a matrix by removing alternatively columns and rows that sum to 0. If the matrix is dense or if every columns sum to more than 0, then nothing is changed.
}
\examples{
set.seed(1)
B  <- matrix(sample(c(0,0,0,1),80,replace=TRUE), nrow = 8, ncol =  10)
ReducedMatrix(B)

}
\author{
Raphael Jauslin \email{raphael.jauslin@unine.ch}
}
