% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphing_functions.R
\name{plotEthnogramSplitByTonality}
\alias{plotEthnogramSplitByTonality}
\title{Plot Tonality-colored Ethnogram}
\usage{
plotEthnogramSplitByTonality(
  data_path,
  graph_title = "Ethnogram Split By Tonality",
  graph_subtitle = "Tonality: Signal/noise"
)
}
\arguments{
\item{data_path}{The full path to the Excel file exported from DeepSqueak}

\item{graph_title}{The title for the graph (there is a default title if not specified)}

\item{graph_subtitle}{The subtitle for the graph (there is a default subtitle if not specified)}
}
\value{
A ggplot2 visualization of the ethnogram shown in the viewer window, which can be manually exported.
}
\description{
Plots a tonality ethnogram, representing tonality (clarity) of calls throughout the recording.
}
\examples{
\dontrun{plotEthnogramSplitByTonality(
  data_path = "inst/extdata/Example_Mouse_Data.xlsx",
  graph_title = "myTitle", graph_subtitle = "myDescription"
)}

}
