% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardModels.R
\name{m8}
\alias{m8}
\title{Create an M8 type extension of the Cairns-Blake-Dowd mortality model}
\usage{
m8(link = c("logit", "log"), xc)
}
\arguments{
\item{link}{defines the link function and random component associated with 
the mortality model. \code{"log"} would assume that deaths follow a 
Poisson distribution and use a log link while \code{"logit"} would 
assume that deaths follow a Binomial distribution and a logit link. 
Note that the default is the logit link.}

\item{xc}{constant defining the cohort age-modulating parameter.}
}
\value{
An object of class \code{"StMoMo"}.
}
\description{
Utility function to initialise a \code{StMoMo} object representing the 
M8 extension of the Cairns-Blake-Dowd mortality model introduced
in Cairns et al (2009).
}
\details{
The created model is either a logit-Binomial or a log-Poisson version of 
the M8 model which has predictor structure 
\deqn{\eta_{xt} = \kappa_t^{(1)} + (x-\bar{x})\kappa_t^{(2)} + (x_c-x)\gamma_{t-x}}
where \eqn{\bar{x}} is the average age in the data and \eqn{x_c} is a
predefined constant. 
Identifiability of the model is accomplished by applying parameters 
constraint
\deqn{\sum_c\gamma_c = 0.}
}
\examples{

M8 <- m8(xc = 89)
wxt <- genWeightMat(55:89,  EWMaleData$years, clip = 3)
M8fit <- fit(M8, data = central2initial(EWMaleData), ages.fit = 55:89)
plot(M8fit, parametricbx = FALSE)

}
\references{
Cairns, A. J. G., Blake, D., Dowd, K., Coughlan, G. D., Epstein, D., 
Ong, A., & Balevich, I. (2009). A quantitative comparison of stochastic
mortality models using data from England and Wales and the United States. 
North American Actuarial Journal, 13(1), 1-35.
}
\seealso{
\code{\link{StMoMo}}, \code{\link{central2initial}}, 
\code{\link{cbd}}, \code{\link{m6}}, \code{\link{m7}}
}
