% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wlsPower.R
\name{compute_wlsPower}
\alias{compute_wlsPower}
\title{Compute power via weighted least squares}
\usage{
compute_wlsPower(
  DesMat,
  EffSize,
  sigma,
  tau = 0,
  eta = NULL,
  AR = NULL,
  rho = NULL,
  gamma = NULL,
  psi = NULL,
  N = NULL,
  CovMat = NULL,
  dfAdjust = "none",
  sig.level = 0.05,
  INDIV_LVL = FALSE,
  INFO_CONTENT = FALSE,
  verbose = 1
)
}
\arguments{
\item{DesMat}{object of class `DesMat`.}

\item{EffSize}{raw effect, i.e. difference between mean under control and
mean under intervention}

\item{sigma}{numeric, residual error of cluster means if no N given.}

\item{tau}{numeric, standard deviation of random intercepts}

\item{eta}{numeric (scalar or matrix), standard deviation of random slopes.
If `eta` is given as scalar, `trtMat` is needed as well.}

\item{AR}{numeric, vector containing up to three values, each between 0 and 1.
Defaults to NULL. It defines the AR(1)-correlation of random effects.
The first element corresponds to the cluster intercept, the second to the
treatment effect and the third to subject specific intercept.
If only one element is provided, autocorrelation of all random effects is
assumed to be the same.
*Currently not compatible with `rho`!=0 !*}

\item{rho}{numeric (scalar), correlation of `tau` and `eta`. The default is no correlation.}

\item{gamma}{numeric (scalar), random time effect}

\item{psi}{numeric (scalar), random subject specific intercept.
Leads to a closed cohort setting}

\item{N}{numeric, number of individuals per cluster. Either a scalar, vector
of length #Clusters or a matrix of dimension #Clusters x timepoints.
Defaults to 1 if not passed.}

\item{CovMat}{numeric, a positive-semidefinite matrix with
(#Clusters \eqn{\cdot} timepoints) rows and columns. If `CovMat` is given,
`sigma`, `tau`, `eta`, `rho`, `gamma` and `psi` as well as `alpha_0_1_2`
must be NULL.}

\item{dfAdjust}{character, one of the following: "none","between-within",
"containment", "residual".}

\item{sig.level}{numeric (scalar), significance level, defaults to 0.05}

\item{INDIV_LVL}{logical, should the computation be conducted on an
individual level? This leads to longer run time and is
mainly for diagnostic purposes.}

\item{INFO_CONTENT}{logical, should the information content of cluster cells be
computed? The default is `TRUE` for designs with less or equal than 2500
cluster cells, otherwise `FALSE`. Ignored if `verbose=0`.}

\item{verbose}{integer, how much information should the function return?
See also under `Value`.}
}
\value{
The return depends on the `verbose` parameter.
If `verbose`=0, only the power is returned
If `verbose`=1 (the default), a list containing power and the
parameters of the specific setting is returned.
If requested (by `verbose`=2) this list also contains relevant matrices.
}
\description{
This function is not intended to be used directly, but rather to be called
by `wlsPower` - the main function of this package.
It expects the design matrix as an input argument `DesMat` and
construct the covariance matrix (if not given as well). These matrices are
used to calculate the variance of the treatment effect estimator which is
then used to calculate the power to detect the assumed treatment effect.
}
