% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data_fnxs.R
\name{sim.stick.data}
\alias{sim.stick.data}
\title{Simulate data under stickbreaking model.}
\usage{
sim.stick.data(n.muts, coes, sigma, d.true, w.wt, geno.matrix, sim.geno.matrix)
}
\arguments{
\item{n.muts}{Number of mutations.}

\item{coes}{Vector of stickbreaking coefficients for each mutation}

\item{sigma}{Noise to add to expectations}

\item{d.true}{The distance to the boundary to use in simulations (d)}

\item{w.wt}{Fitness of the wildtype}

\item{geno.matrix}{Specifies which genotypes to simulated.}

\item{sim.geno.matrix}{If TRUE, simulate geno.matrix. If FALSE, use geno.matrix provided.}
}
\value{
List:\cr
[[1]] \code{fit.matrix} is matrix with (simulated) observed data \cr
[[2]] \code{fit.matrix.exp} is same matrix without error
}
\description{
Simulate data under stickbreaking model.
}
\details{
Function takes coefficients (\code{coes}) and generates the expected
fitness values for each genotype. This set of expected values is given in \code{fit.matrix.exp}.
Then it adds normal error to them to produce the "observed" data (\code{fit.matrix}).
}
\examples{
 geno.matrix <- generate.geno.matrix(5)
 coes <- rep(0.1, 5)
 sim.stick.data(5, coes, 0.1, 1, 1, geno.matrix)
}

