% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_class-Strategy.R
\name{Strategy}
\alias{Strategy}
\title{Create Strategy Object}
\usage{
Strategy(assets, strat = "buyhold"
     , assetValueType = c("price", "logReturn"), weights = NULL, indicators = list()
     , strat.params = list(), volume = 1000000
     , costs.fix = 0, costs.rel = 0
     , printSteps = FALSE)
}
\arguments{
\item{assets}{Time series of class \code{xts} of asset values in either price or log return form on
which the strategy function shall be applied. This is the portfolio of assets.}

\item{strat}{The name of the strategy that should be applied. This can be either a
predefined strategy like MA or EWMA or a self-written function in
which case the full path to the function file to be called must be supplied.}

\item{assetValueType}{Assets can be passed as prices or log returns. In order to identify the
asset value types, either one of the types has to be selected.}

\item{weights}{The portfolio weights for the given assets as time series (dynamic) or numerical (constant) weights.}

\item{indicators}{A list of indicators that might be used within customized strategies. It is recommended to pass a named list.}

\item{strat.params}{The list of parameters and their values required by the strategy function selected with parameter strat.}

\item{volume}{Portfolio volume for trading. Default value is 1 Million.}

\item{costs.fix}{The fix trading costs per trade.}

\item{costs.rel}{The trading costs, relative to the volume. I.e. a value of \code{10E-4} reflects the costs of 10 basis points of the traded volume.}

\item{printSteps}{This is a feature used mainly for debugging the constructor function in order to localize where unspecified errors occur. If set to true, the different steps run within the constructor is printed to the console.}
}
\description{
Creates an object of class \code{Strategy} with the given portfolio data and strategy-function.
}
\examples{
##Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# Own MA-strategy-function
# myStrat.MA <- Strategy(assets=assets, strat="C:/MA_function.R")

##End (Not run)
}

