% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2e_copy.R
\name{e2e_copy}
\alias{e2e_copy}
\title{Make a copy of a named model/variant and documentation in a user defined workspace}
\usage{
e2e_copy(model.name, model.variant, source.path = NULL, dest.path = NULL)
}
\arguments{
\item{model.name}{Name of model to copy.}

\item{model.variant}{Name of model variant to copy.}

\item{source.path}{Relative path from the current working directory to the source model to be copied. Setting source.path="" is valid. Default source.path=NULL, meaning read a North Sea model setup from the package folder extdata/Models.}

\item{dest.path}{Relative path from the current working directory to a destination address in which to create a 'Models' folder if necessary, and then copy the model files. Setting dest.path="" is valid. Default dest.path=NULL in which case the Models folder will be created in a temporary directory.}
}
\value{
A copy of an entire model/variant and the associated documentation folder in the designated workspace.
}
\description{
Make a copy of a named model/variant and documentation in a user defined workspace
}
\examples{
# Copy the 2003-2013 version of the North Sea model supplied with the package into a
# temporary folder: 
    e2e_copy("North_Sea", "2003-2013")

# Dummy example illustrating copy the 2003-2013 version of the North Sea model 
# supplied with the package into a user-defined folder (edit "Folder/Models to 
# your own relative path): 
#   e2e_copy("North_Sea", "2003-2013",dest.path="Folder/Models")

# Dummy example illustrating copying a user model into a user workspace:
# Replace "Folder1/Models" and "Folder2/Models" with your own source.path and dest.path
# remembering that these are relative to the current working directory.
# e.g.... e2e_copy("Modelname", "Modelvariant",
#         source.path="Folder1/Models",
#         dest.path="Folder2/Models")

}
\seealso{
\code{\link{e2e_ls}}, \code{\link{e2e_read}}
}
