test_that("check the function that extracts new initial conditions from the end of a run", {

#-----------------------------------------------------------------------------------------------------------------
# In this test an 'initial conditions' data set is extracted from the end of a run of the North Sea model and
# compared with the initial conditions input file stored in the /Param folder o fthe model.
#-----------------------------------------------------------------------------------------------------------------
#
# The following non-exported functions in the package are needed for the test:
# source("internal.R")
#
#-----------------------------------------------------------------------------------------------------------------

#Run the North Sea 1970-1990 model and use the function 'extract_new_initial_cond_from_end_of_run() to pull out new initial conditions

model<-e2e_read(model.name="North_Sea",
                  model.variant="1970-1999",
                  model.ident="base")
results <- e2e_run(model,nyears=5,csv.output=FALSE)
new_initial<- e2e_extract_start(model, results,csv.output=FALSE)

# Find out if the initial conditions objects generated by the function match the structure expected for the model input
model.path <-   model$setup$model.path
#setupdata  <-	read.model.setup(model.path)			# Models/Model/Variant/MODEL_SETUP.csv

# setupdata[21] = "initial_values_Testbed.csv"

#pf_initial<-readcsv(model.path, PARAMETERS_DIR, setupdata[21],header=FALSE,row.names=1) # no header!
pf_initial<- get.model.file(model.path, PARAMETERS_DIR, file.pattern=INITIAL_STATE, header=FALSE, row.names=1) # no header!

#nrow(new_initial)
#nrow(pf_initial)

nneg<-nrow(pf_initial) - length( which(row.names(new_initial) == row.names(pf_initial)))
# checks that the rownames in the new initial data are the same as in the input file from /Param. nneg should = 0
#nneg

#............................
#............................

#Implement testthat checks...

expect_equal(nrow(new_initial),nrow(pf_initial))
expect_equal(nneg,0)

})

