% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_causal_forest.R
\name{ple_causal_forest}
\alias{ple_causal_forest}
\title{Patient-level Estimates: Causal Forest}
\usage{
ple_causal_forest(Y, A, X, Xtest, tune = FALSE, num.trees = 500,
  family = "gaussian", mod.A = "mean", ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{tune}{If TRUE, use grf automatic hyper-parameter tuning. If FALSE (default), no tuning.}

\item{num.trees}{Number of trees (default=500)}

\item{family}{Outcome type ("gaussian", "binomial"), default is "gaussian"}

\item{mod.A}{Model for estimating P(A|X). Default is "mean" calculates the sample mean.
If mod.A="RF", estimate P(A|X) using regression_forest (applicable for non-RCTs).}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained causal_forest and regression_forest models.
 \itemize{
  \item mod - trained model(s)
}
}
\description{
Uses the causal forest algorithm (Athey, Tibshirani, and Wager 2019; grf R package) to
obtain patient-level estimates. Used for continuous or binary outcomes.
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

\donttest{
require(grf)
mod1 = ple_causal_forest(Y, A, X, Xtest=X)
summary(mod1$mu_train)

}


}
