# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Calibration using raking ratio  
#'
#' @description This function is inspired by the function \code{\link[sampling:calib]{calib}} of the package sampling. It computes the g-weights of the calibration estimator.
#' 
#' @param Xs A matrix of calibration variables.
#' @param d A vector, the initial weights.
#' @param total A vector that represents the initial weights.
#' @param q A vector of positive value that account for heteroscedasticity.
#' @param max_iter An integer, the maximum number of iterations. Default = 500.
#' @param tol A scalar that represents the tolerance value for the algorithm. Default = 1e-9.
#'
#' @details
#' More details on the different calibration methods can be read in Tillé Y. (2020).
#'
#' @return A vector, the value of the g-weights.
#'
#' @author Raphaël Jauslin \email{raphael.jauslin@@unine.ch}
#'
#'
#' @references Tillé, Y. (2020). \emph{Sampling and estimation from finite populations}. Wiley, New York
#' 
#' @export
calibRaking <- function(Xs, d, total, q, max_iter = 500L, tol = 1e-9) {
    .Call(`_StratifiedSampling_calibRaking`, Xs, d, total, q, max_iter, tol)
}

#' @title Disjunctive
#'
#' @description
#' This function transforms a categorical vector into a matrix of indicators.
#'
#' @param strata A vector of integers that represents the categories.
#'
#' @return A matrix of indicators.
#'
#' @author Raphaël Jauslin \email{raphael.jauslin@@unine.ch}
#'
#' @examples
#' strata <- rep(c(1,2,3),each = 4)
#' disj(strata)
#'
#' @export
disj <- function(strata) {
    .Call(`_StratifiedSampling_disj`, strata)
}

#' @title Number of categories
#'
#' @description
#' This function returns the number of factor in each column of a categorical matrix.
#'
#' @param Xcat A matrix of integers that contains categorical vector in each column.
#'
#' @return A row vector that contains the number of categories in each column.
#'
#' @author Raphaël Jauslin \email{raphael.jauslin@@unine.ch}
#'
#' @export
#' 
#' @examples
#' Xcat <-  matrix(c(sample(x = 1:6, size = 100, replace = TRUE),
#'             sample(x = 1:6, size = 100, replace = TRUE),
#'             sample(x = 1:6, size = 100, replace = TRUE)),ncol = 3)
#' ncat(Xcat)
ncat <- function(Xcat) {
    .Call(`_StratifiedSampling_ncat`, Xcat)
}

#' @title Disjunctive for matrix  
#'
#' @description
#' This function transforms a categorical matrix into a matrix of indicators variables.
#'
#' @param strata A matrix of integers that contains categorical vector in each column.
#'
#' @return A matrix of indicators.
#'
#' @author Raphaël Jauslin \email{raphael.jauslin@@unine.ch}
#' 
#' @examples
#' Xcat <-  matrix(c(sample(x = 1:6, size = 100, replace = TRUE),
#'             sample(x = 1:6, size = 100, replace = TRUE),
#'             sample(x = 1:6, size = 100, replace = TRUE)),ncol = 3)
#' disjMatrix(Xcat)
#'
#' @export
disjMatrix <- function(strata) {
    .Call(`_StratifiedSampling_disjMatrix`, strata)
}

