% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlegend.R
\name{nlegend}
\alias{nlegend}
\title{New legend element}
\usage{
nlegend(temp = FALSE, t = "Text", xt = 1.3, xmax = 5, xmin = -1.2,
  ymax = 1.5, ymin = -ymax)
}
\arguments{
\item{temp}{whether to plot a template for visualisation}

\item{t}{text to provide the legend}

\item{xt}{the x position of the text}

\item{xmin, xmax, ymin, ymax}{the x and y limits for the plotting area}
}
\description{
Prepares a plotting environment for a new element of a
multifigure legend
}
\examples{
opar <- par("mar")

par(mar = c(0,0,0,0))

layout(matrix(1:6, 6, 1, byrow = TRUE))

nlegend(t = paste("Shaded stuff. By the way you can\\nwrite",
                  "text in several lines if needed"))

rect(-1,-1,1,1, density = 10)

nlegend(TRUE, t = "Text: left side at x = 1.3 (default xt value)")

par(mar = opar)

}
\seealso{
\code{\link{multigons}}, \code{\link{bedtext}},
\code{\link{infobar}} and \code{\link{ylink}}
}
