% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whiteSet.R
\name{whiteSet}
\alias{whiteSet}
\title{Sets the plot environment to draw a long data set}
\usage{
whiteSet(xlim, ylim, xtick = NA, ytick = NA, nx = 1, ny = 1,
  xaxs = "i", yaxs = "i", xarg = list(tick.ratio = 0.5),
  yarg = list(tick.ratio = 0.5, las = 1), add = FALSE)
}
\arguments{
\item{xlim, ylim}{the x and y limits (e.g. xlim = c(-1,1))}

\item{xtick, ytick}{the interval between each major ticks for x and y}

\item{nx, ny}{the number of intervals between major ticks to be
divided by minor ticks in the x and y axes}

\item{xaxs, yaxs}{The style of axis interval calculation to be used
for the x and y axes. By default it is "i" (internal): it just finds an axis
with pretty labels that fits within the original data range. You can also set
it to "r" (regular): it first extends the data range by 4 percent at each end
and then finds an axis with pretty labels that fits within the extended
range. See ?par for further explanation}

\item{xarg, yarg}{a list of arguments to feed to minorAxis() for the
x and y axes. See the ?minorAxis help page for the possible arguments. See
?merge_list for further information.}

\item{add}{whether to add to an existing plot}
}
\description{
Sets the plot environment to draw a long dataset. It is without
background, and with only axes with major and minor ticks.
}
\examples{
y <- c(0,11,19,33)
x <- c(1,2,2.5,4)

a <- min(y)
b <- max(y)

f <- encase(a-1,b,5)

whiteSet(c(0,4), f, ytick = 5, ny = 5, xaxs = "r")

points(x, y, pch=19)
}
\seealso{
Similar functions: \code{\link{greySet}} and \code{\link{blackSet}}

To create axes with major and minor ticks: \code{\link{minorAxis}}

To print a plot in pdf: \code{\link{pdfDisplay}}

To automatically determine pretty interval limits: \code{\link{encase}}
}
