% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centresvg.R
\name{centresvg}
\alias{centresvg}
\alias{centersvg}
\title{Draws a pointsvg object around a given point}
\usage{
centresvg(object, x, y, xfac = 1, yfac = 1, xadj = 0, yadj = 0,
  forget = NULL, front = NULL, back = NULL, standard = FALSE,
  keep.ratio = FALSE, col = NA, border = "black", density = NA,
  angle = 45, lty = par("lty"), lwd = par("lwd"), scol = border,
  slty = lty, slwd = lwd, plot = TRUE, output = FALSE)

centersvg(object, x, y, xfac = 1, yfac = 1, xadj = 0, yadj = 0,
  forget = NULL, front = NULL, back = NULL, standard = FALSE,
  keep.ratio = FALSE, col = NA, border = "black", density = NA,
  angle = 45, lty = par("lty"), lwd = par("lwd"), scol = border,
  slty = lty, slwd = lwd, plot = TRUE, output = FALSE)
}
\arguments{
\item{object}{a pointsvg object (svg object imported as data frame
using \code{\link{pointsvg}}).}

\item{x, y}{numeric vectors of coordinates where the object should be
drawn.}

\item{xfac}{the x size factor.}

\item{yfac}{the y size factor.}

\item{xadj}{value specifying the x adjustment of the drawing.}

\item{yadj}{value specifying the y adjustment of the drawing.}

\item{forget}{the elements that should be discarded, by their id
or index (i.e. name or number of appearance).}

\item{front, back}{the elements to be put in front and back position,
by their id or index (i.e. name or number of appearance). By default the
order is the one of the original .svg file.}

\item{standard}{whether to standardise (centre to (0,0), rescale so
that extreme points are at -1 and 1) or not (T or F)}

\item{keep.ratio}{if the object is to be  standardised, whether to
keep the x/y ratio (T or F)}

\item{col}{the polygones background color. If density is specified with
a positive value this gives the color of the shading lines.}

\item{border}{the lines color.}

\item{density}{the density of shading lines, in lines per inch. The
default value of NULL means that no shading lines are drawn.}

\item{angle}{the slope of shading lines, given as an angle in degrees
(counter-clockwise)}

\item{lty, lwd}{the border line type and width, see ?par for details.}

\item{scol, slty, slwd}{the colour, type and width of the shading lines.}

\item{plot}{whether to add to a plot}

\item{output}{whether to output the new object coordinates}
}
\description{
Draws a svg object imported as data frame using
\code{\link{pointsvg}} around a given point.
}
\details{
The \code{\link{centresvg}} and
\code{\link{framesvg}} have a lot of similarities with the
\code{\link{multigons}} function: the graphical parameters are mostly
identical. However there is a strong distinction between the -svg functions
and multigons: when providing several graphical arguments, multigons will
attribute them to each polygon, whereas the .svg functions will use them for
each repetition of the .svg object. Using the latter, the graphical
parameters will be applied to all the elements of a drawing. If you want
a finer personalisation you have to use multigons and multilines (or an
hybrid of the two, yet to be coded).
}
\examples{
object <- example.ammonite

plot(c(-10,10), c(-10,10), type = "n")

centresvg(object, 5, 5, xfac = 2, yfac = 2,lty = 1,density = 20, angle = 45)

points(5,5,pch = 19, col = "blue")

}
\seealso{
Similar functions: \code{\link{framesvg}} and \code{\link{placesvg}}

Change the drawing: \code{\link{changesvg}} and \code{\link{clipsvg}}

Uses \code{\link{ignore}} to avoid drawing unnecessary objects
}
