% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flip.lim.R
\name{flip.lim}
\alias{flip.lim}
\title{Inverts the intervals}
\usage{
flip.lim(lim = NULL, l = NULL, r = NULL, b = "[]", xlim = NA)
}
\arguments{
\item{lim}{an object convertible into a lim object: either a vector
of length 2 or a list of n left (1st element) and n right (2ndt element)
interval limits}

\item{l}{a vector of n left interval limits}

\item{r}{a vector of n right interval limits}

\item{b}{a character vector for the interval boundaries rules: "[]"
(or "closed") to include both boundaries points, "][" (or "()" and "open") to
exclude both boundary points, "[[" (or "[)","right-open" and"left-closed") to
include only the left boundary point, and "]]" (or "(]", "left-open",
"right-closed") to include only the right boundary point. The notation is
simplified to "[]", "[[", "]]" and "][" only.}

\item{xlim}{the minimum and maximum of the new lim object (minimum and
maximum of the old one if NA; is the default)}
}
\value{
a lim object of intervals in between the provided intervals
}
\description{
Gives a negative of the intervals of a lim object
}
\examples{
l   <- c(1,3,5,7,9,10)
r   <- c(3,4,7,8,9,11)
b   <- "]["

xlim <- c(-1,15)

res <- flip.lim(l = l, r = r, b = b, xlim = xlim)

plot(1,1,type = "n", xlim = c(-4, 20), ylim = c(0.3, 1.8))
rect(l, 1.1, r, 1.4, col = "green", border = "darkgreen", lwd = 3)
rect(res$l, 1, res$r, 0.7, col = "red", border = "darkred", lwd = 3)
abline(v = xlim)

}
\seealso{
\code{\link{as.lim}}
}
