% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.clockwise.R
\name{is.clockwise}
\alias{is.clockwise}
\title{Identify whether the points of a polygon are ordered clockwise}
\usage{
is.clockwise(x, y, i = rep("A1", length(x)), get.pos = F)
}
\arguments{
\item{x, y}{the coordinates of the polygons}

\item{i}{the identification of the polygons if there are multiple ones}

\item{get.pos}{get the output as a list of the result and of the output of
octapos()}
}
\value{
logical values for each polygon: TRUE for clockwise, FALSE for
counterclockwise, NA for ambiguous order, typically in lines or the polygons
whose lines cross each other (although sometimes such polygons are still
giving T or F values, as this function only consider certain reference
points, for more details see \code{\link{octapos}}).
}
\description{
Identify whether the points of a polygon are ordered clockwise
}
\examples{
# Generate some polygons ----

x1 <- c(0,1,0.5)
y1 <- c(3,3,4)
i1 <- rep("P1", 3)
s1 <- 1:3

x2 <- c(3,3.5,4)
y2 <- c(3,4,3)
i2 <- rep("P2", 3)
s2 <- 1:3

x3 <- c(0,0.5,1)
y3 <- c(1, 1.5,2)
i3 <- rep("P3", 3)
s3 <- 1:3

x4 <- c(3,4,4,3)
y4 <- c(1,2,1,2)
i4 <- rep("P4", 4)
s4 <- 1:4

x5 <- c(1,2,3,3,2,1)
y5 <- c(-0.5,0.4,-0.5,0.5,-0.4,0.5)
i5 <- rep("P5", 6)
s5 <- 1:6

x6 <- c(1,2,3,3,2,1)
y6 <- c(-2,-1,-2,-1,-2.5,-1)
i6 <- rep("P6", 6)
s6 <- 1:6

x <- c(x1, x2, x3, x4, x5, x6)
y <- c(y1, y2, y3, y4, y5, y6)
i <- c(i1, i2, i3, i4, i5, i6)
s <- c(s1, s2, s3, s4, s5, s6)

# Test whether they are clockwise or not ----

is.clockwise(x = x, y = y, i = i)

# Visualise the result ----

plot.new()
plot.window(xlim = c(-0.5,5.5), ylim = c(-2.5,4.5))

axis(1)
axis(2)

multigons(i = i, x = x, y = y)

center.x   <- c(0.5, 3.5, 0.5, 3.5, 2, 2)
center.y   <- c(3.4, 3.4, 2, 1.5, 0, -1.5)
center.lab <- c("P1", "P2", "P3", "P4", "P5", "P6")

text(x = center.x, y = center.y, labels = center.lab)

text(x = x, y = y, labels = s)

}
