% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/octashift.R
\name{octashift}
\alias{octashift}
\title{Shifts the order of polygon points}
\usage{
octashift(x, y, i, pos, clockwise = NA)
}
\arguments{
\item{x, y}{the coordinates of the polygons}

\item{i}{the identification of the polygons if there are multiple ones}

\item{pos}{an integer from 1 to 8 identifying a points, based on the
formalism of the \code{\link{octapos}} function}

\item{clockwise}{whether to have the points in the polygon be ordered
clockwise (T), counterclockwise (F). If NA (which is the default), this will
not be addressed}
}
\value{
a data frame with $x, $y and $i of the polygons as columns
}
\description{
Shifts the order of polygon points based on octagon-like
reference
}
\examples{
xy <- c(-3,-4,-3,0,-1,-2,-1,0,1,2,1,3,4,5,4,3)
dt <- c(1,1.5,2,1,1,1.5,2,2,1,1.5,2,1,1,1.5,2,2)
id <- c(rep("B1",3), rep("B2",5), rep("B3",3), rep("B4",5))

out <- octashift(xy, dt, id, pos = 3, clockwise = TRUE)

par(mfrow = c(2,1))

plot.new()
plot.window(xlim = range(xy) + c(-1, 1), ylim = range(dt) + 0.5 * c(-1, 1))

axis(1)
axis(2)

multilines(i = id, x = xy, y = dt)

plot.new()
plot.window(xlim = range(xy) + c(-1, 1), ylim = range(dt) + 0.5 * c(-1, 1))

axis(1)
axis(2)

multilines(i = out$i, x = out$x, y = out$y)

}
