###############################################################################-
##
## This program creates the figures for the manuscript using the
## prca data that is included in this package
##
##
## Instead of using rm(list = ls()), make sure you start with a fresh R
## by restarting R -> Control+Shift+F10
# cat("\014") # Cleans the console
## Load needed libraries
## If SubgrPlots package is not installed, then open project and use following lines or
## in the build window, click Install and Restart
# devtools::build()
# devtools::install()

library(SubgrPlots) # Loads this package. Install it first
library(survival)
library(ggplot2)
library(dplyr)

data(prca)
dat <- prca
dat %>%
  mutate(survival = factor(ifelse(survtime > 24 , "Yes", "No"), levels = c("No", "Yes")),
         trt = rx) -> dat
dat %>%
  dplyr::select(trt, bm, hx, pf, survival) %>%
  dplyr::group_by(trt, bm, hx, pf, survival) %>%
  dplyr::summarise(Freq = n()) -> alldat
alldat %>%
  ungroup() %>%
  mutate(trt = ifelse(trt == 0 , "Control", "Treatment"),
         bm = ifelse(bm == 0 , "No", "Yes"),
         hx = ifelse(hx == 0 , "No", "Yes")) -> alldat

pdf("paper/figures/17-alluvial-plot-surv.pdf", width = 5, height = 5)
plot_alluvial(alldat[,c(5,1,3,2,4)], freq = alldat$Freq,
              xw=0.2,cw = 0.12,cex = 1,
              alpha  = 0.8,
              col=ifelse(alldat$survival  == "Yes",
                         ifelse(alldat$trt  == "Treatment","#80b1d3","#d5e2eb"),
                         ifelse(alldat$trt  == "Treatment","#faa8d2","#fbe0ee")),
              layer = alldat$trt  == 1, rotate = 90, las = 2, bottom.mar = 5)
dev.off()

