% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08-labbe-plot-function.r
\name{plot_labbe}
\alias{plot_labbe}
\title{L'Abbe plot for subgroup effect size}
\usage{
plot_labbe(dat, covari.sel, trt.sel, resp.sel, outcome.type, effect = c("HR",
  "RMST"), size.shape = 1/18, adj.ann.subgrp = 1/30, font.size = c(1, 1,
  0.85, 0.85), title = NULL, lab.xy = NULL, time = mean(dat[,
  resp.sel[1]]), show.ci = TRUE)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of the two covariates}

\item{trt.sel}{a covariate index specifying the treatment code}

\item{resp.sel}{a covariate index specifying the response variable}

\item{outcome.type}{a string specifying the type of the response variable, it can be "continuous", or "binary".}

\item{effect}{Either "HR" of "RMST". Only when outcome.type = "survival"}

\item{size.shape}{a parameter controlling the height and width of the squares and the size is proportional to the ratio of subgroup sample sizes
over the full population size.}

\item{adj.ann.subgrp}{a parameter controlling the distance between a square and its corresponding subgroup label; also, the line
gap between the legend text for subgroups.}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the main title, the second is for
for x-axis and y-axis labels; the thrid is for the legend text of subgroups; the fourth is for the subgroup
labels near the corresponding squares.}

\item{title}{a string specifying the main title.}

\item{lab.xy}{a list of two strings specifying the labels of the x and y axes.}

\item{time}{time for calculating the survival in each subgroup}

\item{show.ci}{A logical indicating whether to show an additional line for confidence intervals}
}
\description{
this function produces a L'Abbe plot showing the treatment effect size of subgroups defined by the categories of covariates. The
x-axis and y-axis represent the treatment effect estimate from the control and treatment group, respectively. The dashed dignal
indicates no effect, and the solid diagnal line corresponds to the full population effect estimate. The squares represent subgroups,
and the red or blue dashed lines have a length which show the magnitude of the lower or upper bound of the 95% C.I for subgroup
treatment effect estimates. If the solid diagonal line cross all the blue or red lines, it may indicate homogeneity across subgroup
with repective to the full population effect estimate. Note that the overall size of squares which represent subgroups can be
adjusted by setting different values on the associated input argument. In addition, the function uses log odd ratio for displaying
subgroup effect sizes in binary and survival data, respectively.
}
\examples{
library(dplyr)

# Load the data to be used
data(prca)
dat <- prca
dat \%>\%
  mutate(bm = factor(ifelse(bm == 0 , "No", "Yes")),
         hx = factor(ifelse(hx == 0 , "No", "Yes")))-> dat

## 8. Labbe Plot -----------------------------------------------------------
lab.xy = list("Control Group Estimate", "Treatment Group Estimate")
plot_labbe(dat = dat,
           covari.sel = c(4,5,6,7),
           trt.sel = 3,
           resp.sel = c(1,2),
           outcome.type = "survival",
           effect = "RMST",
           lab.xy = lab.xy,
           size.shape = 0.2,
           adj.ann.subgrp = 1/30,
           time=50, show.ci = FALSE)

}

