% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpk-IVxbyx.R
\name{IVXbyX}
\alias{IVXbyX}
\title{Create x-by-x Psuedo-IV Curves}
\usage{
IVXbyX(df, corr_temp = "median", N_c)
}
\arguments{
\item{df}{Dataframe containing IV data. Typically, a raw dataframe prior
to filtering for irradiance/temperature. Within this package environment, use
\code{\link{read_df_raw}} to generate this from a .csv}

\item{corr_temp}{The temperature from which to create the correction
factor. Pass the string "median" in order for the function to automatically
calculate the median module temperature at 1 sun irradiance and use it.}

\item{N_c}{Number of Cells in series; the total number of cells in the system.}
}
\value{
Psuedo-IV Curve data (dataframe) grouped from time periods of set length.
}
\description{
This function moves through IV curve data x-by-x,
generating psuedo IV curves and binding them together into the output.
}
\examples{
\donttest{
df_full <- IVXbyX(df_wbw, corr_temp = "median", 4)
}

}
