% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpk-power_loss-phys.R
\name{power_loss_phys_bat}
\alias{power_loss_phys_bat}
\title{Physical Model Power Loss Modes}
\usage{
power_loss_phys_bat(df_iv, init_df, corr_T = "median", N_c)
}
\arguments{
\item{df_iv}{Dataframe containing psuedo-IV curves. Generate with \code{\link{IVXbyX}}.}

\item{init_df}{Dataframe containing first several weeks of real-world IV data.
Generate with \code{\link{select_init_df}}}

\item{corr_T}{The temperature from which to create the correction
factor. Pass the string "mean" in order for the function to automatically
calculate the mean temperature and use it.}

\item{N_c}{Number of cells in series; The total number of cells in the system.}
}
\value{
dataframe containing information about power loss due to various power loss modes
}
\description{
This function decouples power loss to different loss modes, specifically I mismatch,
recombination, uniform current loss, and Rs loss, from the changes in IV features.
}
\examples{
\donttest{
df_full <- IVXbyX(df_wbw, corr_temp = "median", 4)

df_init <- select_init_df(df_wbw, days = 21)

T_corr <- median_temp(df_wbw)

res <- power_loss_phys_bat(df_full, df_init, corr_T = T_corr, N_c = 4);
}

}
