% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpk-power_loss-phys.R
\name{power_loss_phys_bat}
\alias{power_loss_phys_bat}
\title{Physical Model Power Loss Modes}
\usage{
power_loss_phys_bat(df_iv, init_df, corr_T = 40, N_c, ddiv_param = 0.06)
}
\arguments{
\item{df_iv}{Dataframe containing psuedo-IV curves. Generate with \code{\link{IVXbyX}}.}

\item{init_df}{Dataframe containing first several weeks of real-world IV data.
Generate with \code{\link{select_init_df}}}

\item{corr_T}{The temperature from which to create the correction
factor. Pass only numeric values.}

\item{N_c}{Number of cells in series; The total number of cells in the system.}

\item{ddiv_param}{Parameter passed to ddiv::IVfeature for 'crtvalb'}
}
\value{
dataframe containing information about power loss due to various power loss modes
}
\description{
This function decouples power loss to different loss modes, specifically current mismatch,
recombination, uniform current loss, and Rs loss, from the changes in IV features.
}
\examples{
\donttest{
df <- read_df_raw(df_wbw,0.02,7)
df_init <- select_init_df(df, days = 21)
df_full <- IVXbyX(df, corr_temp = 30, 60)
res <- power_loss_phys_bat(df_full, df_init, corr_T = 30, N_c = 60)
}
}
