% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA_design.R
\name{ANOVA_design}
\alias{ANOVA_design}
\title{Design function used to specify the parameters to be used in simulations}
\usage{
ANOVA_design(
  design,
  n,
  mu,
  sd,
  r = 0,
  labelnames = NULL,
  plot = Superpower_options("plot")
)
}
\arguments{
\item{design}{String specifying the ANOVA design.}

\item{n}{Sample size in each condition}

\item{mu}{Vector specifying mean for each condition}

\item{sd}{standard deviation for all conditions (or a vector specifying the sd for each condition)}

\item{r}{Correlation between dependent variables (single value or matrix)}

\item{labelnames}{Optional vector to specifying factor and condition names (recommended, if not used factors and levels are indicated by letters and numbers)}

\item{plot}{Should means plot be printed (defaults to TRUE)}
}
\value{
Returns single list with simulated data, design, design list, factor names, formulas for ANOVA, means, sd, correlation, sample size per condition, correlation matrix, covariance matrix, design string, labelnames, labelnameslist, factor names, meansplot

\describe{
  \item{\code{"dataframe"}}{A sample dataframe of what data could look like given the proposed parameters.}
  \item{\code{"design"}}{\code{aov} The design string, e.g. "2b*2w".}
  \item{\code{"design_list"}}{The list of variables in the design.}
  \item{\code{"frml1"}}{The first formula created for this design.}
  \item{\code{"frml2"}}{The second formula created for this design.}
  \item{\code{"mu"}}{Vector of means.}
  \item{\code{"sd"}}{Vector of standard deviations.}
  \item{\code{"r"}}{Common correlation coefficient.}
  \item{\code{"n"}}{Sample size per cell. Can be entered as a single value or list of sample sizes for each condition. If unequal n is entered then the design can only be passed onto ANOVA_power.}
  \item{\code{"cor_mat"}}{The correlation matrix.}
  \item{\code{"sigmatrix"}}{The variance-covariance matrix.}
  \item{\code{"design_factors"}}{Total number of within-subjects factors.}
  \item{\code{"labelnames"}}{List of the label names.}
  \item{\code{"labelnameslist"}}{Secondary list of labelnames}
  \item{\code{"factornames"}}{List of the factor titles.}
  \item{\code{"meansplot"}}{Plot of the experimental design.}

}
}
\description{
Design function used to specify the parameters to be used in simulations
}
\section{Warnings}{

Varying the sd or r (e.g., entering multiple values) violates assumptions of homoscedascity and sphericity respectively
}

\examples{
## Set up a within design with 2 factors, each with 2 levels,
## with correlation between observations of 0.8,
## 40 participants (who do all conditions), and standard deviation of 2
## with a mean pattern of 1, 0, 1, 0, conditions labeled 'condition' and
## 'voice', with names for levels of "cheerful", "sad", and "human", "robot"
ANOVA_design(design = "2w*2w", n = 40, mu = c(1, 0, 1, 0), sd = 2, r = 0.8,
      labelnames = c("condition", "cheerful", "sad", "voice", "human", "robot"))
}
