% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICA_SurvSurv_copula.R
\name{compute_ICA_SurvSurv}
\alias{compute_ICA_SurvSurv}
\title{Compute Individual Causal Association for a given D-vine copula model in the
Survival-Survival Setting}
\usage{
compute_ICA_SurvSurv(
  copula_par,
  rotation_par,
  copula_family1,
  copula_family2,
  n_prec,
  q_S0,
  q_T0,
  q_S1,
  q_T1,
  composite,
  marginal_sp_rho = TRUE,
  seed = 1,
  mutinfo_estimator = NULL,
  plot_deltas = FALSE,
  restr_time = +Inf
)
}
\arguments{
\item{copula_par}{Parameter vector for the sequence of bivariate copulas that
define the D-vine copula. The elements of \code{copula_par} correspond to
\eqn{(c_{12}, c_{23}, c_{34}, c_{13;2}, c_{24;3}, c_{14;23})}.}

\item{rotation_par}{Vector of rotation parameters for the sequence of
bivariate copulas that define the D-vine copula. The elements of
\code{rotation_par} correspond to \eqn{(c_{12}, c_{23}, c_{34}, c_{13;2},
  c_{24;3}, c_{14;23})}.}

\item{copula_family1}{Copula family of \eqn{c_{12}} and \eqn{c_{34}}. For the
possible options, see \code{loglik_copula_scale()}. The elements of
\code{copula_family} correspond to \eqn{(c_{12}, c_{34})}.}

\item{copula_family2}{Copula family of the other bivariate copulas. For the
possible options, see \code{loglik_copula_scale()}. The elements of
\code{copula_family2} correspond to \eqn{(c_{23}, c_{13;2}, c_{24;3}, c_{14;23})}.}

\item{n_prec}{Number of Monte Carlo samples for the computation of the mutual
information.}

\item{q_S0}{Quantile function for the distribution of \eqn{S_0}.}

\item{q_T0}{Quantile function for the distribution of \eqn{T_0}.}

\item{q_S1}{Quantile function for the distribution of \eqn{S_1}.}

\item{q_T1}{Quantile function for the distribution of \eqn{T_1}.}

\item{composite}{(boolean)  If \code{composite} is \code{TRUE}, then the surrogate
endpoint is a composite of both a "pure" surrogate endpoint and the true
endpoint, e.g., progression-free survival is the minimum of time-to-progression
and time-to-death.}

\item{marginal_sp_rho}{(boolean) Compute the sample Spearman correlation
matrix? Defaults to \code{TRUE}.}

\item{seed}{Seed for Monte Carlo sampling. This seed does not affect the global
environment.}

\item{mutinfo_estimator}{Function that estimates the mutual information
between the first two arguments which are numeric vectors. Defaults to
\code{FNN::mutinfo()} with default arguments.
@param plot_deltas (logical) Plot the sampled individual treatment effects?}

\item{plot_deltas}{Plot the sampled individual causal effects? Defaults to
\code{FALSE}.}

\item{restr_time}{Restriction time for the potential outcomes. Defaults to
\code{+Inf} which means no restriction. Otherwise, the sampled potential outcomes
are replace by \code{pmin(S0, restr_time)} (and similarly for the other potential
outcomes).}
}
\value{
(numeric) A Named vector with the following elements:
\itemize{
\item ICA
\item Spearman's rho, \eqn{\rho_s (\Delta S, \Delta T)} (if asked)
\item Marginal association parameters in terms of Spearman's rho (if asked):
\deqn{\rho_{s}(T_0, S_0), \rho_{s}(T_0, S_1), \rho_{s}(T_0, T_1),
 \rho_{s}(S_0, S_1), \rho_{s}(S_0, T_1),
 \rho_{s}(S_1, T_1)}
\item Survival classification proportions (if asked):
\deqn{\pi_{harmed}, \pi_{protected}, \pi_{always}, \pi_{never}}
}
}
\description{
The \code{\link[=compute_ICA_SurvSurv]{compute_ICA_SurvSurv()}} function computes the individual causal
association (and associated quantities) for a fully identified D-vine copula
model in the survival-survival setting.
}
