% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boosting_function.R
\name{summary.boosting}
\alias{summary.boosting}
\title{Summary of boosting model selection}
\usage{
\method{summary}{boosting}(object, all_beta = NULL, ...)
}
\arguments{
\item{object}{output from boosting_core function.}

\item{all_beta}{default value is FALSE. If this is set to TRUE the 
coefficient estimates for all the parameters will be printed.}

\item{...}{ignored}
}
\value{
list containing the coefficient vector, number of boosting
  iterations, and resulting formula from the variable selection.
}
\description{
This function displays the variables selected from a model generated with the
boosting_core function.
}
\examples{
data <- simulate_survival_cox(true_beta=c(1,1,1,1,1,0,0,0,0,0))
formula <- as.formula("Surv(time,delta) ~ strata(strata_idx) + V1 + V2 + 
V3 + V4 + V5 + V6 + V7 + V8 + V9 + V10" )
boosting.output <- boosting_core(formula, data, rate=0.1, num_iter=500)
summary.boosting(boosting.output)

}
\keyword{boosting}
\keyword{gradient}
