% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IAEISE.R
\name{IAEISE}
\alias{IAEISE}
\title{IAEISE}
\usage{
IAEISE(object, sp_matrix, IRange = range(object[, 1]))
}
\arguments{
\item{object}{object of class \code{Surv} on the testing set created by Surv function.}

\item{sp_matrix}{a matrix of predicted values of survival probabilities for the testing set.}

\item{IRange}{a vector contains all discrete time points corresponding to the predicted probability in sp_matrix.
Or the scale you want to get the IAE and ISE;  .}
}
\value{
Estimates of the IAE and ISE
}
\description{
Two ways of the continuous-time approach to continuous-time identification based on least-squares and least-absolute errors are proposed.
Integrate Absolute Error and Integrate Square Error.To evaluate the performance of survival models methods
Lower values of IAE or ISE indicate better performances.
}
\references{
Marron, J. S. , &  Wand, M. P. . (1992). Exact mean integrated squared error. Annals of Statistics, 20(2), 712-736.
HooraMoradian, DenisLarocque, & FranoisBellavance. (2017). \\(l_1\\) splitting rules in survival forests. Lifetime Data Analysis, 23(4), 671–691.
Kowalczuk, & Z. (1998). Integrated squared error and integrated absolute error in recursive identification of continuous-time plants. Control 98 Ukacc International Conference on (Vol.1998, pp.693-698). IET.
#' @examples

library(survival)
library(SurvMetrics)
set.seed(123)
N = 100
mydata = SDGM4(N, p = 20, c_step = -0.5)
index.train = sample(1:N,2/3*N)
data.train = mydata[index.train,]
data.test = mydata[-index.train,]

time_interest = sort(data.train$time[data.train$status == 1])
sp_matrix = matrix(sort(runif(nrow(data.test)*length(time_interest)),
  decreasing = TRUE), nrow = nrow(data.test))
object = Surv(data.test$time,data.test$status)

#a vector for all the distinct time
IAEISE(object, sp_matrix, time_interest)
#a range
IAEISE(object, sp_matrix, c(12,350))
}
\author{
Hanpu Zhou \email{zhouhanpu@csu.edu.cn}
}
