% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CVrankSurv_fct.R
\name{CVrankSurv_fct}
\alias{CVrankSurv_fct}
\title{Main function of SurvRank.}
\usage{
CVrankSurv_fct(data, t.times, cv.out, cv.in, fs.method = "lasso.rank",
  nr.var = 10, sd1 = 0.95, ncl = 1, weig.t = T, n1 = 0.1,
  c.time = 10, ...)
}
\arguments{
\item{data}{input of data as a list in the format: list.name$x data.frame of covariates. list.name$y response as a survival object, derived from \code{\link{Surv}}.}

\item{t.times}{number of times the cross-validation should be repeated}

\item{cv.out}{number of folds in outer cross validation loop (for estimation of the predictive accuracy)}

\item{cv.in}{number of folds in inner cross validation loop (for model selection on the training set)}

\item{fs.method}{Defaults to "lasso.rank". Ranking method to be applied. One of c("lasso.rank","conc.rank","rf.rank","boost.rank","cox.rank","rpart.rank","randcox.rank","wang.rank")}

\item{nr.var}{Number of variables up to which stepwise selection should be carried out. Has to be smaller than n number of observations.}

\item{sd1}{factor to which sparser solutions should be chosen. Not maximum Survival AUC in inner loop is used in stepwise selection, instead \code{max(survAUC)*sd1} leading to sparser solutions}

\item{ncl}{Defaults to 1. Number of clusters for parallel execution.}

\item{weig.t}{Defaults to TRUE. Should a weighting of features be performed.}

\item{n1}{used in weighting function if weig.t=T. Find details in \code{\link{weighting_fct}}}

\item{c.time}{as defined in package \code{survAUC} time; a positive number restricting the upper limit of the time range under consideration.}

\item{...}{arguments that can be passed to underlying functions, not used now}
}
\value{
Output of the \code{CVrankSurv_fct}, basically a list containing the following elements
\item{\code{method}}{ranking method}
\item{\code{accuracy$ranking}}{full ranking of all model estimations}
\item{\code{accuracy$pred.in}}{averaged inner AUCs of stepwise selection}
\item{\code{accuracy$pred.out}}{predictions of testset}
\item{\code{accuracy$used.rank}}{only used features according to stepwise selection}
\item{\code{accuracy$used.rank1se}}{only used features according to stepwise selection with factor \code{sd1}}
\item{\code{accuracy$auc.out}}{matrix of dimension \code{cv.out} times \code{t.times} of survival AUCs.}
\item{\code{accuracy$auc.out1se}}{matrix of dimension \code{cv.out} times \code{t.times} of survival AUCs with factor \code{sd1}.}
\item{\code{rank.mat}}{matrix of ranks per feature. If not selected, it is set to number of features.}
\item{\code{out.mat}}{0/1 matrix for features selected}
\item{\code{out.mat1se}}{0/1 matrix for features selected with factor \code{sd1} application}
\item{\code{top1se}}{unweighted toplist with factor \code{sd1}}
\item{\code{toplist}}{unweighted toplist}
\item{\code{weighted}}{weighted toplist with applied weighting function}
\item{\code{rank}}{toplist of ranked features according to ranks}
}
\description{
Main input function for SurvRank.
}
\details{
details to follow
}
\examples{
## Simulating a survival data set
N=100; p=10; n=4
x=data.frame(matrix(rnorm(N*p),nrow=N,p))
beta=rnorm(n)
mx=matrix(rnorm(N*n),N,n)
fx=mx[,seq(n)]\%*\%beta/3
hx=exp(fx)
ty=rexp(N,hx)
tcens=1-rbinom(n=N,prob=.3,size=1)
y=Surv(ty,tcens)
data=list()
data$x<-x; data$y<-y
## Ranking the features according to their significance in the univariate cox models
out.cox<-CVrankSurv_fct(data,2,3,3,fs.method="cox.rank")
## Ranking the features according to the LASSO algorithm
\dontrun{
out.lasso<-CVrankSurv_fct(data,2,5,5,fs.method="lasso.rank")}
}
\keyword{SurvRank}

