#' Reduced PATH tobacco use data set
#'
#' A subset of data from the Population Assessment of
#'  Tobacco and Health (PATH) Study
#'
#' @format ## `reducedPATHdata`
#' A data frame with 132 rows and 107 columns:
#' \describe{
#'   \item{PERSONID}{Participant ID}
#'   \item{R01_AC1002}{Ever smoked a cigarette}
#'   ...
#' }
#' @source <https://www.icpsr.umich.edu/web/NAHDAP/studies/36498>
"reducedPATHdata"


#' Reduced NYTS data set
#'
#' A subset of data from the National Youth Tobacco
#'  Survey (NYTS) Study
#'
#' @format ## `reducedNYTS2021data`
#' A data frame with 1150 rows and 24 columns:
#' \describe{
#'   \item{psu2}{Primary sampling unit}
#'   \item{v_stratum2}{Strata information}
#'   ...
#' }
#' @source <https://www.cdc.gov/tobacco/data_statistics/surveys/nyts/data/index.html>
"reducedNYTS2021data"
