% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_02a_claim_covariates.R
\name{relativity_template}
\alias{relativity_template}
\title{Template to input Covariate Relativities}
\usage{
relativity_template(factors)
}
\arguments{
\item{factors}{named list of vectors, containing the name of the covariates
and associated factors in vector form.}
}
\value{
Returns a dataframe object, with five columns:
\tabular{ll}{
\code{factor_i} \tab Factor i. \cr
\code{factor_j} \tab Factor j. \cr
\code{level_ik} \tab Level within Factor i. \cr
\code{level_jl} \tab Level within Factor j. \cr
\code{relativity} \tab Relativity between \code{level_ik} and \code{level_jl}, defaults to \code{NA}.
}
}
\description{
Constructs a template for the covariate relativities based on the
inputed covariates. Note that only non-zero relativities and one cross-factor
relativity is needed for each factor pair.
}
\details{
Suppose that there are \eqn{m} covariates labelled \eqn{c_i}, \eqn{i=1,...,m},
and that covariate \eqn{c_i} can assume one and only one of \eqn{n_i} values,
\eqn{x_{ik}}, \eqn{k=1,...,n_i}. The total number of available covariate
values is \eqn{n = \sum_{i=1}^m n_o}.

Now set up an \eqn{n \times n} matrix \eqn{F}, consisting of sub-matrices
\eqn{F_{ij}}, \eqn{i,j = 1, ... ,m} of dimension \eqn{n_i \times n_j}. The
diagonal blocks \eqn{F_{ii}} will quantify first-order relativities on claims
attributes, and the off-diagonal blocks \eqn{F_{ij}}, \eqn{j \neq i} will quantify
second-order effects. Let \eqn{f_{ij,kl}} denote the \eqn{(k, l)} element of
\eqn{F_{ij}}. This element operates as a multiplier of the claim attribute
when covariates \eqn{c_i} and \eqn{c_j} take values \eqn{x_{ik}} and \eqn{x_jl}
respectively. Since \eqn{c_i} can assume only one of the values \eqn{x_ik},
\eqn{f_{ii, kl} = 0} for \eqn{k \neq l}, and so \eqn{F_{ii}} is diagonal for
all \eqn{i=1, ..., m}. Moreover, \eqn{f_{ij,kl} = f_{ji,lk}}, so that
\eqn{F} is symmetric and \eqn{f_{ij,kl} > 0}.
}
\examples{
factors <- list(
    "Legal Representation" = c("Y", "N"),
    "Injury Severity" = as.character(1:6),
    "Age of Claimant" = c("0-15", "15-30", "30-50", "50-65", "over 65")
)

relativity_freq <- relativity_template(factors)
relativity_sev <- relativity_template(factors)

# Default Values
relativity_freq$relativity <- c(
    1, 1,
    0.95, 1, 1, 1, 1, 1,
    0.05, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,
    0.53, 0.3, 0.1, 0.05, 0.01, 0.01,
    1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,
    0.183, 0.192, 0.274, 0.18, 0.171
)

relativity_sev$relativity <- c(
    2, 1,
    1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,
    0.6, 1.2, 2.5, 5, 8, 0.4,
    1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,
    1, 1, 1, 0.97, 0.95,
    1, 1, 1, 0.95, 0.9,
    1, 1, 1, 1, 1,
    1.25, 1.15, 1, 0.85, 0.7
)

head(relativity_freq)
head(relativity_sev)

test_covariates_obj <- covariates(factors)
test_covariates_obj <- set.covariates_relativity(
    covariates = test_covariates_obj,
    relativity = relativity_freq,
    freq_sev = "freq"
)
test_covariates_obj <- set.covariates_relativity(
    covariates = test_covariates_obj,
    relativity = relativity_sev,
    freq_sev = "sev"
)

}
