% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.taf.R
\name{read.taf}
\alias{read.taf}
\title{Read TAF Table from File}
\usage{
read.taf(file, check.names = FALSE, stringsAsFactors = FALSE,
  fileEncoding = "UTF-8", ...)
}
\arguments{
\item{file}{a filename.}

\item{check.names}{whether to enforce regular column names, e.g. convert
column name \samp{"3"} to \samp{"X3"}.}

\item{stringsAsFactors}{whether to import strings as factors.}

\item{fileEncoding}{character encoding of input file.}

\item{\dots}{passed to \code{read.csv}.}
}
\value{
A data frame in TAF format, or a list of data frames if \code{file} is a
directory or a vector of filenames.
}
\description{
Read a TAF table from a file into a data frame.
}
\details{
Alternatively, \code{file} can be a directory or a vector of filenames, to
read many tables in one call.
}
\examples{
\dontrun{
write.taf(catage.taf, "catage.csv")
catage <- read.taf("catage.csv")

write.taf(catage)
file.remove("catage.csv")
}

}
\seealso{
\code{\link{read.csv}} is the underlying function used to read a table from a
file.

\code{\link{write.taf}} writes a TAF table to a file.

\code{\link{TAF-package}} gives an overview of the package.
}
