\name{designMatrices}

\alias{designMatrices}
\alias{print.designMatrices}
\alias{designMatrices.mfr}
\alias{designMatrices.mfr2}
\alias{.A.matrix}
\alias{rownames.design}
\alias{.A.PCM2}
\alias{.A.PCM3}

\title{
Generation of Design Matrices
}

\description{
Generate design matrices, and display them at console.
}
\usage{
designMatrices(modeltype = c("PCM", "RSM"), maxKi = NULL, resp = resp,
    ndim = 1, A = NULL, B = NULL, Q = NULL, R = NULL, constraint = "cases" ,...)
    
print.designMatrices(X, ...)

designMatrices.mfr(resp, formulaA = ~ item + item:step, facets = NULL, 
    constraint = c("cases", "items"), ndim = 1, Q=NULL, A=NULL, B=NULL ,
    progress=FALSE)
designMatrices.mfr2(resp, formulaA = ~ item + item:step, facets = NULL, 
    constraint = c("cases", "items"), ndim = 1, Q=NULL, A=NULL, B=NULL ,
    progress=FALSE)    
    
.A.matrix(resp, formulaA = ~ item + item*step, facets = NULL, 
    constraint = c("cases", "items") , progress=FALSE , maxKi=NULL)
rownames.design(X)

.A.PCM2( resp, Kitem=NULL , constraint = "cases" , Q = NULL) 
   # generates ConQuest parametrization of partial credit model

.A.PCM3( resp, Kitem=NULL ) # parametrization for A matrix in the dispersion model
}

\arguments{
  \item{modeltype}{
     Type of item response model. Until now, the
     partial credit model (\code{PCM}; \code{'item+item*step'}) and
     the rating scale model (\code{RSM}; \code{'item+step'}) is implemented.
}
  \item{maxKi}{
     A vector containing the maximum score per item
}
  \item{resp}{
     Data frame of item responses
}
  \item{ndim}{
     Number of dimensions
}
  \item{A}{
     The design matrix for linking item category parameters
     to generalized item parameters \eqn{\xi}.
}
  \item{B}{
     The scoring matrix of item categories on \eqn{\theta}
     dimensions.
}
  \item{Q}{
     A loading matrix of items on dimensions
     with number of rows equal the number
     of items and the number of columns equals the
     number of dimensions in the item response model.
}
 \item{R}{
     This argument is not used
}
 \item{X}{
     Object generated by \code{designMatrices}. This argument is used in
     \code{print.designMatrices} and \code{rownames.design}.
}
\item{formulaA}{
    An \R formula object for generating the \code{A} design matrix.
    Variables in \code{formulaA} have to be included in \code{facets}.
            }
\item{facets}{
    A data frame with observed facets. The number of rows must be equal
    to the number of rows in \code{resp}.
            }
\item{constraint}{
    Constraint in estimation: \code{cases} assumes zero means
    of trait distributions and \code{items} a sum constraint of
    zero of item parameters 
        }
\item{Kitem}{Maximum number of categories per item}
\item{progress}{Display progress for creation of design matrices}
  \item{\dots}{
     Further arguments
}
}



\details{
The function \code{.A.PCM2} generates the Conquest parametrization
of the partial credit model.

The function \code{.A.PCM3} generates the parametrization for the \eqn{A}
design matrix in the dispersion model for ordered data (Andrich, 1982).
}

%\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
%}

\references{
Andrich, D. (1982). An extension of the Rasch model for ratings providing
both location and dispersion parameters. \emph{Psychometrika}, \bold{47},
105-113.	
}

%\author{
%%  ~~who you are~~
%}

\note{
The function \code{designMatrices.mfr2} handles multi-faceted design for
items with differing number of response options.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
See \code{\link{sim.mfr}} for some examples for creating design matrices.	
%% ~~objects to See Also as \code{\link{help}}, ~~~
}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% EXAMPLES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\examples{
###########################################################
# different parametrizations for ordered data
data( data.gpcm )
resp <- data.gpcm

# parametrization for partial credit model
A1 <- designMatrices( resp= resp )$A
# item difficulty and threshold parametrization
A2 <- .A.PCM2( resp )
# dispersion model of Andrich (1982)
A3 <- .A.PCM3( resp )
# rating scale model
A4 <- designMatrices( resp= resp , modeltype="RSM" )$A
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{Design matrices}
%% \keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
