% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{KepertWindField}
\alias{KepertWindField}
\title{Kepert Wind Field}
\usage{
KepertWindField(rMax, vMax, vFm, thetaFm, f, Rlam, VZ, surface)
}
\arguments{
\item{rMax}{radius of maximum winds in km}

\item{vMax}{maximum wind velocity calculation in m/s}

\item{vFm}{input forward velocity of TC}

\item{thetaFm}{input forward direction of TC}

\item{f}{single coriolis parameter at the centre of TC in hz}

\item{Rlam}{two columns for distances and Cartesian direction clocwise from the x axis from grid points to TC centre in km}

\item{VZ}{array two columns velocity then vorticity}

\item{surface}{equals one if winds are reduced from the gradient level to the surface, otherwise gradient winds.}
}
\value{
array with two columns for zonal and meridional wind speed vector-components.
//@example KepertWindField(20,20,2,10,-1e-4,rbind(c(50,35),c(45,40)),rbind(c(20,2),c(22,3)))
}
\description{
Grid point vortex Wind field, wind vectors. Kepert, J., 2001: The Dynamics of Boundary Layer Jets within the Tropical Cyclone Core.Part I : Linear Theory.J.Atmos.Sci., 58, 2469 - 2484
}
\keyword{internal}
