% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCIApathfinder.R
\name{get_body_part_names}
\alias{get_body_part_names}
\title{Get body part names}
\usage{
get_body_part_names(collection = NULL, modality = NULL)
}
\arguments{
\item{collection}{TCIA collection name. If \code{collection} is \code{NULL},
body part names from all collections will be returned. To get a list of available collection
names, call \code{\link{get_collection_names}}.}

\item{modality}{Modality name. If \code{modality} is \code{NULL}, body part names
from all modalities will be returned. To get a list of available modality names, call
\code{\link{get_modality_names}} or see
\href{https://wiki.cancerimagingarchive.net/display/Public/DICOM+Modality+Abbreviations}{DICOM Modality Abbreviations}.}
}
\value{
List containing elements:
\itemize{
  \item \code{body_parts}: character vector of body part names
  \item \code{content}: parsed API response content
  \item \code{response}: API response
}
}
\description{
Get body part names
}
\examples{
\dontrun{
get_body_part_names()
get_body_part_names(collection = "TCGA-BRCA")
get_body_part_names(modality = "MR")
get_body_part_names(collection = "TCGA-BRCA", modality = "MR")
}

}
\seealso{
\code{\link{get_collection_names}},
\code{\link{get_modality_names}},
\href{https://wiki.cancerimagingarchive.net/display/Public/DICOM+Modality+Abbreviations}{DICOM Modality Abbreviations},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+Programmatic+Interface+\%28REST+API\%29+Usage+Guide}{TCIA REST API Usage Guide},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+API+Return+Values}{TCIA API object definitions}
}
