% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmri_2dvisual.R
\name{fmri_2dvisual}
\alias{fmri_2dvisual}
\title{visualization of the 2D brain (axial, sagittal and coronal) with the activated areas}
\usage{
fmri_2dvisual(
  pval,
  axis_ls,
  hemody_data = NULL,
  mask,
  p_threshold = 0.05,
  legend_show = TRUE,
  method = "scale_p",
  color_pal = "YlOrRd",
  multi_pranges = TRUE,
  mask_width = 1.5
)
}
\arguments{
\item{pval}{a 3D array of p-values used to plot activated area of the brain}

\item{axis_ls}{a list with two elements. The first element is the character of 'x', 'y', 'z'.
The second element is an integer showing a specific slice on the fixed axis identified in the first element.}

\item{hemody_data}{a parameter to have the plot with/without hemodynamic contour. The default is NULL to make the plot 
without hemodynamic contour, otherwise assign a 3D array of the hemodynamic data.}

\item{mask}{a 3D nifti or 3D array of data to show the shell of the brain}

\item{p_threshold}{NULL or a numeric value that can be selected randomly below 0.05 to 
drop all p-values above the threshold. If 'low5_percent' method is used, 
make 'p_threshold' as NULL. The default is 0.05.}

\item{legend_show}{a logical parameter to specify whether the final plot has legend}

\item{method}{a string that represents method for the plot. 
There are 3 options: 'min_max', 'scale_p' and 'low5_percent'. The default is 'scale_p'.
'min_max' is to draw plot based on the color scale of the minimum and maximum of the p value; 
'scale_p' is to draw the plot with fixed color scale for fixed range of p value; 
'low5_percent' is to draw the plot for the smallest 5 percent of p value when all the p values are not significant.}

\item{color_pal}{the name of the color palettes provided by \code{RColorBrewer}. The default is "YlOrRd".}

\item{multi_pranges}{an option under 'scale_p' method to decide whether there are at most 9 colors 
in the legend for the ranges of p value, or at most 4 colors. 
The default is TRUE, choosing the larger number of colors for the plot.}

\item{mask_width}{a numeric value to specify the width of mask contour. The default is 1.5.}
}
\value{
a plot drawn by \code{ggplot2}
}
\description{
a visualization method, using \code{ggplot2} to draw the brain 
from axial, sagittal and coronal view with activated area identified by p-values
}
\details{
The function \code{fmri_2dvisual} is used to find activated part of the brain 
based on given p values from sagittal, axial and coronal view. When providing input of 
the p-values, the specific plane and index to slice on, the mask data and 
the hemodynamic data of the brain, a plot will be generated with the heat map 
for the activated parts, the black contour showing the position of the brain, 
and the blue contour representing the hemodynamic contour.
}
\examples{
# sample 3D data of mask provided by the package
dim(mask)
# sample 3D p value provided by the package
dim(phase2_pval)

# plot the sagittal, coronal and axial view of this p value generated from the brain fMRI data
\donttest{
fmri_2dvisual(phase2_pval, list('x',40), hemody_data=NULL, mask=mask, p_threshold=0.05)
}

}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
