% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{computeVAB}
\alias{computeVAB}
\title{A Vector Summary of the Betti Curve}

\description{
For a given persistence diagram \eqn{D=\{(b_i,d_i)\}_{i=1}^N}, \code{computeVAB()} vectorizes the Betti Curve \deqn{\beta(t)=\sum_{i=1}^N w(b_i,d_i)\bold 1_{[b_i,d_i)}(t),} where the weight function  \eqn{w(b,d)\equiv 1}
}

\usage{
computeVAB(D, homDim, scaleSeq)
}

\arguments{
\item{D}{matrix with three columns containing the dimension, birth and death values respectively}

\item{homDim}{homological dimension (0 for \eqn{H_0}, 1 for \eqn{H_1}, etc.)}

\item{scaleSeq}{numeric vector of increasing scale values used for vectorization}

}

\value{
A numeric vector whose elements are the average values of the Betti curve computed between each pair of
consecutive scale points of \code{scaleSeq}=\eqn{\{t_1,t_2,\ldots,t_n\}}:
\deqn{\Big(\frac{1}{\Delta t_1}\int_{t_1}^{t_2}\beta(t)dt,\frac{1}{\Delta t_2}\int_{t_2}^{t_3}\beta(t)dt,\ldots,\frac{1}{\Delta t_{n-1}}\int_{t_{n-1}}^{t_n}\beta(t)dt\Big),}
where \eqn{\Delta t_k=t_{k+1}-t_k}
}

\author{Umar Islambekov, Hasani Pathirana}

\references{
1. Chazal, F., & Michel, B. (2021). An Introduction to Topological Data Analysis: Fundamental and Practical Aspects for Data Scientists. Frontiers in Artificial Intelligence, 108.

2. Chung, Y. M., & Lawson, A. (2022). Persistence curves: A canonical framework for summarizing persistence diagrams. Advances in Computational Mathematics, 48(1), 1-42.
}

\examples{
N <- 100 
set.seed(123)
# sample N points uniformly from unit circle and add Gaussian noise
X <- TDA::circleUnif(N,r=1) + rnorm(2*N,mean = 0,sd = 0.2)

# compute a persistence diagram using the Rips filtration built on top of X
D <- TDA::ripsDiag(X,maxdimension = 1,maxscale = 2)$diagram 

scaleSeq = seq(0,2,length.out=11) # sequence of scale values

# compute vector of averaged Bettis (VAB) for homological dimension H_0
computeVAB(D,homDim=0,scaleSeq)

# compute vector of averaged Bettis (VAB) for homological dimension H_1
computeVAB(D,homDim=1,scaleSeq)
}