\name{tdmDispatchTuner}
\alias{tdmDispatchTuner}
\title{Helper function for \code{\link{tdmCompleteEval}}.}
\usage{
  tdmDispatchTuner(tuneMethod, confFile, spotStep, tdm,
    envT, dataObj)
}
\arguments{
  \item{tuneMethod}{the tuning algorithm given as a string.
  Possible values are \{ "spot" | "lhd" | "cmaes" | "cma_j"
  | "bfgs" | "powell" \}.}

  \item{confFile}{the configuration file.}

  \item{spotStep}{which step to execute for \link{SPOT} .
  Values "rep" and "auto" are supported by TDMR.}

  \item{tdm}{the TDMR object}

  \item{envT}{the environment variable}

  \item{dataObj}{the \code{\link{TDMdata}} object
  containing the data set (train/vali part and test part)}
}
\value{
  the result of the tuning algorithm.
}
\description{
  tdmDispatchTuner selects and starts the tuner specified
  by tuneMethod. \cr See the 'Details' section of
  \code{\link{tdmCompleteEval}} for a list of available
  tuners
}
\author{
  Wolfgang Konen, FHK, Sep'2010 - Oct'2011
}
\seealso{
  \code{\link{tdmCompleteEval}}
}
\keyword{internal}

