% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPC.R
\name{PPC}
\alias{PPC}
\alias{PPC_print}
\title{Projected Principal Component Analysis}
\usage{
PPC_print(x, m, A, D, p)
}
\arguments{
\item{x}{A matrix of input data.}

\item{m}{The number of principal components to extract (integer).}

\item{A}{The true factor loadings matrix (matrix).}

\item{D}{The true uniquenesses matrix (matrix).}

\item{p}{The number of variables (integer).}
}
\value{
A list containing:
\item{Ap}{Estimated factor loadings.}
\item{Dp}{Estimated uniquenesses.}
\item{MSESigmaA}{Mean squared error for factor loadings.}
\item{MSESigmaD}{Mean squared error for uniquenesses.}
\item{LSigmaA}{Loss metric for factor loadings.}
\item{LSigmaD}{Loss metric for uniquenesses.}
}
\description{
This function computes Projected Principal Component Analysis (PPC) for the provided input data, estimating factor loadings and uniquenesses. It calculates mean squared errors and loss metrics for the estimated values compared to true values.
}
\examples{
library(MASS)
library(relliptical)
library(SOPC)

PPC_MSESigmaA <- c()
PPC_MSESigmaD <- c()
PPC_LSigmaA <- c()
PPC_LSigmaD <- c()

p <- 10
m <- 5
n <- 2000

mu <- t(matrix(rep(runif(p, 0, 1000), n), p, n))
mu0 <- as.matrix(runif(m, 0))
sigma0 <- diag(runif(m, 1))
F <- matrix(mvrnorm(n, mu0, sigma0), nrow = n)
A <- matrix(runif(p * m, -1, 1), nrow = p)

lower <- c(rep(-0.5, p - 3), -5, -5, -Inf)
upper <- c(rep(0.5, p - 3), 5, 5, Inf)
Sigma <- diag(runif(p, 0, 1))
mut <- runif(p, 0, 10)

trnor <- rtelliptical(n, mut, Sigma, lower, upper, dist = "Normal")
epsilon <- matrix(trnor, nrow = n)
D <- Sigma

data <- mu + F \%*\% t(A) + epsilon

result <- PPC_print(data, m, A, D, p)

data_G <- data.frame(n = n,
                     MSEA = result$MSESigmaA,
                     MSED = result$MSESigmaD,
                     LSA = result$LSigmaA,
                     LSD = result$LSigmaD)

print(data_G)
}
