% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TGS.R
\name{LearnTgs}
\alias{LearnTgs}
\title{Implementing the TGS Algorithm.}
\usage{
LearnTgs(isfile = 0, input.data.filename = "", num.timepts = 0,
  true.net.filename = "", input.wt.data.filename = "",
  is.discrete = TRUE, num.discr.levels = 2, discr.algo = "",
  mi.estimator = "mi.pca.cmi", apply.aracne = FALSE,
  clr.algo = "CLR", max.fanin = 14, allow.self.loop = TRUE,
  scoring.func = "BIC", input.dirname = "", output.dirname = "",
  json.file = "")
}
\arguments{
\item{isfile}{1 if the parameters are given in a json file otherwise 0.}

\item{input.data.filename}{name of the file containing the data without the directory name. It can be .tsv or .Rdata file only.}

\item{num.timepts}{number of distinct timepoints}

\item{true.net.filename}{File containing the true network without the directory name. In case non empty then should contain .Rdata file with object name 'true.net.adj.matrix'}

\item{input.wt.data.filename}{File containing Input Wild Type data without the directory name. If it is not empty hen must be a .tsv file having first row containing names of genes except (1,1) and second row should have the WT values except (2,1)th cell.}

\item{is.discrete}{whether the data is discretized or not}

\item{num.discr.levels}{number of discreteized levels that each gene has (if already discretized) or it should have (if it is to be discretized)}

\item{discr.algo}{The algo to follow in case of not discretized. Possible values:- {discretizeData.2L.Tesla,discretizeData.2L.wt.l}}

\item{mi.estimator}{which method to use for estimating the mutual information matrix. Generally ‘mi.pca.cmi’ is used}

\item{apply.aracne}{ARACNE is applied to refine the mutual information matrix. In case true then TGS+ version is used otherwise the original TGS variant is executed}

\item{clr.algo}{CLR algo to use Possible values :- {CLR, CLR2, CLR2.1, CLR3, spearman}}

\item{max.fanin}{the maximum number of regulators each gene can have}

\item{allow.self.loop}{Whether to allow self loops in the graph}

\item{scoring.func}{Which scoring func to use}

\item{input.dirname}{Name of the directory where input files are. By default your current directory unless specified otherwise}

\item{output.dirname}{Name of the directory where output files are to be stored. By default your current directory unless specified otherwise}

\item{json.file}{name of the json file along with directory if parameters are to be read from json file}
}
\description{
It Uncovers the underlying temporal sequence of gene regulatory events in the form of time-varying Gene Regulatory Networks (GRNs)
It learns the time-varying GRN structures independently of each other, without imposing any structural constraint. However,
it is time intensive and hence not suitable for large-scale GRNs.
}
\examples{
\dontrun{
LearnTgs(0,input.data.filename = "DmLc3E.RData", num.timepts = 6, is.discrete = TRUE,
 num.discr.levels = 2, mi.estimator = "mi.pca.cmi", apply.aracne = FALSE,
 clr.algo = "CLR", max.fanin = 14, allow.self.loop = TRUE,
 input.dirname = "location where file is stored",
 output.dirname = "location where output needs to be stored")

LearnTgs(0,input.data.filename = "DmLc3L.RData", num.timepts = 2, is.discrete = TRUE,
 num.discr.levels = 2, mi.estimator = "mi.pca.cmi", apply.aracne = FALSE,
 clr.algo = "CLR", max.fanin = 14, allow.self.loop = TRUE,
 input.dirname = "location where file is stored",
 output.dirname = "location where output needs to be stored")
}

}
