% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.functions.R
\name{txa.screen}
\alias{txa.screen}
\title{Screening of site by taxa matrix}
\usage{
txa.screen(txa, minSplt = minSplt)
}
\arguments{
\item{txa}{A site by taxon matrix of sampled counts at each
sampling location.}

\item{minSplt}{The minimum split size used for partitioning.  The
default is to use the argument form the original TITAN function
call.}
}
\value{
A site by taxon matrix of sampled counts at each sampling
  location.
}
\description{
Screens site by taxa matrix for potential minimum occurrence and
frequency problems.
}
\details{
This function provides a warning for low numbers of observations
and data sets with too few observations to make any reasonable
interpretation.  It also warns users when 100 percent occurence
is detected and how much of the data set meets this criterion, as
IndVal based analyses are not ideal for this type of data and we
might recommend other techniques (Baker and King 2013). The
function also assess whether occurrence frequencies for any taxa
fall below 3, and call attention to very small minimum split
sizes.
}
\author{
M. Baker and R. King
}
\references{
Baker, ME and RS King.  2010. A new method for
  detecting and interpreting biodiversity and ecological
  community thresholds.  Methods in Ecology and Evolution 1(1):
  25:37.

Baker ME and RS King. 2013. Of TITAN and straw men:
  an appeal for greater understanding of community data.
  Freshwater Science 32(2):489-506.
}
\keyword{TITAN}
\keyword{~kwd2}

