% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_taxa.R
\name{plot-taxa}
\alias{plot-taxa}
\alias{plot_taxa}
\alias{plotTaxa}
\title{Plots taxon-specific change points}
\usage{
plot_taxa(
  titan.out,
  z1 = TRUE,
  z2 = TRUE,
  interval = TRUE,
  prob95 = FALSE,
  z.med = FALSE,
  xlabel = "Environmental Gradient",
  log = "",
  at = NULL,
  xmin = min(titan.out$sppmax[, 8]),
  xmax = max(titan.out$sppmax[, 12]) * 1.05,
  tck = 0.025,
  bty = "u",
  ntick = 6,
  prtty = TRUE,
  dig = 1,
  leg.x = 0.8,
  leg.y = 10,
  cex.taxa = 0.75,
  cex = 1.25,
  cex.axis = 1.25,
  cex.leg = 1.25,
  cex.lab = 1.25,
  legend = TRUE,
  col1 = "black",
  fil1 = "black",
  col2 = "black",
  fil2 = "white",
  write = FALSE,
  all = FALSE,
  ...
)

plotTaxa(...)
}
\arguments{
\item{titan.out}{A TITAN output object.}

\item{z1}{A logical specifying whether decreasing taxa should be plotted.}

\item{z2}{A logical specifying whether decreasing taxa should be plotted.}

\item{interval}{A logical specifying whether quantiles of bootstrapped change
points should be plotted.}

\item{prob95}{A logical specifying whether change-point locations should be
plotted on the basis of their 5th (for increasers) and 95th (for
decreasers) quantile versus their observed values.}

\item{z.med}{A logical specifying whether (1) change point magnitudes should
be obtained from the median z score across bootstrap replicates and (2)
whether the locations should be plotted on the basis of the 50th quantile
of change-point locations (i.e., if prob95=FALSE).}

\item{xlabel}{A character string for the x axis label.}

\item{log}{A graphical argument specifying whether an axis should be log
scaled.}

\item{at}{A graphical argument controlling the locatino of the x axis label.}

\item{xmin}{A graphical argument specifying the value of the x axis minimum.}

\item{xmax}{A graphical argument specifying the value of the x axis maximum.}

\item{tck}{A graphical argument specifying the scale of axis tick marks.}

\item{bty}{A graphical argument specyfying the box type around the plot.}

\item{ntick}{A graphical argument specifying the default number of axis tick
marks.}

\item{prtty}{A logical specifying whether pretty() should be used for axis
plotting.}

\item{dig}{A numeric argument controlling the number of decimal digits in
axis labels.}

\item{leg.x}{A graphical argument specifying the x coordinate of the legend.}

\item{leg.y}{A graphical argument specifying the y coordinate of the legend.}

\item{cex.taxa}{A graphical argument specifying the scaling of the taxa
names.}

\item{cex}{A graphical argument specifying the scaling of the figure.}

\item{cex.axis}{A graphical argument specifying the scaling of the axes.}

\item{cex.leg}{A graphical argument specifying the scaling of the legend.}

\item{cex.lab}{A graphical argument specifying the scaling of the lables.}

\item{legend}{A logical specifying whether or not to plot the legend.}

\item{col1}{A graphical argument specifying the color of group 1 symbols.}

\item{fil1}{A graphical argument specifying the color of group 1 fills.}

\item{col2}{A graphical argument specifying the color of group 2 symbols.}

\item{fil2}{A graphical argument specifying the color of group 2 fills.}

\item{write}{A logical specifying whether summary tables are written to
screen.}

\item{all}{A logical specifying whether all taxa with p<0.05 should be
plotted.}

\item{...}{An argument for passing generic plotting function parameters.}
}
\value{
A plot of decreasing and/or increasing taxon-specific change points
along the environmental gradient.
}
\description{
Creates a plot of taxon-specific change points with optional quantiles
conveying uncertainty resulting from bootstrapped samples and optional
filtering by pure and reliable taxa.
}
\details{
The fuction assumes that TITAN objects contain bootstrap summaries and
filtering information and automatically determines whether this is the case.
Without bootstrap summaries, only observed change-point locations and z-score
magnitudes will be plotted.  The plotting function automatically interprets
whether observed change-point values were obtained using IndVal or z-score
maxima.  The interval option is for turning off the intervals for TITAN
objects that contain bootstrap information. The prob95 is recommended for
communicating uncertainty involving management or policy action, whereas the
z.med option is recommended for increasingly robust estimates (by
incorporating uncertainty associated with the sample) of taxon-specific
change-point locations beyond those provided by the default (i.e., observed
values).
}
\note{
Should not be used with output objects from TITAN v1.0.
}
\examples{

data(glades.titan)
plot_taxa(glades.titan, xlabel = "Surface Water TP (ug/l)")


}
\references{
Baker, ME and RS King.  2010. A new method for detecting and
interpreting biodiversity and ecological community thresholds.  Methods in
Ecology and Evolution 1(1): 25:37.

King, RS and ME Baker  2010. Considerations for identifying and
interpreting ecological community thresholds. Journal of the North American
Benthological Association 29(3):998-1008.
}
\seealso{
\code{\link[=plot_sumz]{plot_sumz()}}, \code{\link[=plot_cps]{plot_cps()}}
}
\author{
M. Baker and R. King
}
